% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/henryLM.r
\name{henry.LM}
\alias{henry.LM}
\title{Henry Isotherm Linear Analysis}
\usage{
henry.LM(Ce, Qe)
}
\arguments{
\item{Ce}{the numerical value for the equilibrium capacity}

\item{Qe}{the numerical value for the adsorbed capacity}
}
\value{
the linear regression, parameters for the Henry isotherm, and model
error analysis
}
\description{
It describes the appropriate fit to the adsorption of adsorbate
at relatively low concentrations such that all adsorbate molecules are
secluded from their nearest neighbours.
}
\examples{
Ce <- c(0.01353, 0.04648, 0.13239, 0.27714, 0.41600, 0.63607, 0.80435, 1.10327, 1.58223)
Qe <- c(0.03409, 0.06025, 0.10622, 0.12842, 0.15299, 0.15379, 0.15735, 0.15735, 0.16607)
henry.LM(Ce, Qe)
}
\references{
Deocaris, C., & Osio, L. (2020). Fitting Henry’s
Adsorption Isotherm model in R using PUPAIM package.
}
\author{
Paul Angelo C. Manlapaz

Chester C. Deocaris
}
