% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pump_sample.R
\name{pump_sample}
\alias{pump_sample}
\title{Estimate the required sample size (core function)}
\usage{
pump_sample(
  d_m,
  MTP = NULL,
  typesample,
  MDES,
  M = 1,
  numZero = NULL,
  nbar = NULL,
  J = NULL,
  K = NULL,
  target.power,
  power.definition,
  alpha,
  two.tailed = TRUE,
  Tbar,
  numCovar.1 = 0,
  numCovar.2 = 0,
  numCovar.3 = 0,
  R2.1 = 0,
  R2.2 = 0,
  R2.3 = 0,
  ICC.2 = 0,
  ICC.3 = 0,
  rho = NULL,
  rho.matrix = NULL,
  omega.2 = 0,
  omega.3 = 0,
  B = 1000,
  max.steps = 20,
  tnum = 1000,
  start.tnum = tnum/10,
  final.tnum = 4 * tnum,
  parallel.WY.cores = 1,
  updateProgress = NULL,
  max_sample_size_nbar = 10000,
  max_sample_size_JK = 1000,
  tol = 0.01,
  give.optimizer.warnings = FALSE,
  verbose = FALSE
)
}
\arguments{
\item{d_m}{string; a single context, which is a design and model
code. See pump_info() for list of choices.}

\item{MTP}{string, or vector of strings; multiple testing
procedure(s). See pump_info() for list of choices.}

\item{typesample}{string; type of sample size to 
calculate: "nbar", "J", or "K".}

\item{MDES}{scalar or vector; the desired MDES values for each
outcome. Please provide a scalar, a vector of length M, or vector
of values for non-zero outcomes.}

\item{M}{scalar; the number of hypothesis tests (outcomes),
including zero outcomes.}

\item{numZero}{scalar; additional number of outcomes assumed to be
zero. Please provide NumZero + length(MDES) = M, if length(MDES)
is not 1.}

\item{nbar}{scalar; the harmonic mean of the number of level 1
units per level 2 unit (students per school). Note that this is
not the total number of level 1 units, but instead the number of
level 1 units nested within each level 2 unit, so the total
number of level 1 units is nbar x J x K.}

\item{J}{scalar; the harmonic mean of number of level 2 units per
level 3 unit (schools per district). Note that this is not the
total number of level 2 units, but instead the number of level 2
units nested within each level 3 unit, so the total number of
level 2 units is J x K.}

\item{K}{scalar; the number of level 3 units (districts).}

\item{target.power}{target power for search algorithm.}

\item{power.definition}{see pump_info() for 
possible power definitions.}

\item{alpha}{scalar; the family wise error rate (FWER).}

\item{two.tailed}{scalar; TRUE/FALSE for two-tailed or one-tailed
power calculation.}

\item{Tbar}{scalar; the proportion of samples that are assigned to
the treatment.}

\item{numCovar.1}{scalar; number of level 1 (individual)
covariates.}

\item{numCovar.2}{scalar; number of level 2 (school) covariates.}

\item{numCovar.3}{scalar; number of level 3 (district) covariates.}

\item{R2.1}{scalar, or vector of length M; percent of variation
explained by level 1 covariates for each outcome.}

\item{R2.2}{scalar, or vector of length M; percent of variation
explained by level 2 covariates for each outcome.}

\item{R2.3}{scalar, or vector of length M; percent of variation
explained by level 3 covariates for each outcome.}

\item{ICC.2}{scalar, or vector of length M; level 2 (school)
intraclass correlation.}

\item{ICC.3}{scalar, or vector length M; level 3 (district)
intraclass correlation.}

\item{rho}{scalar; assumed correlation between all pairs of test
statistics.}

\item{rho.matrix}{matrix; alternate specification allowing a full
matrix of correlations between test statistics. Must specify
either rho or rho.matrix, but not both.}

\item{omega.2}{scalar, or vector of length M; ratio of variance of
level 2 average impacts to variance of level 2 random intercepts.}

\item{omega.3}{scalar, or vector of length M; ratio of variance of
level 3 average impacts to variance of level 3 random intercepts.}

\item{B}{scalar; the number of permutations for Westfall-Young
procedures.}

\item{max.steps}{how many steps allowed before terminating.}

\item{tnum}{max number of samples for first iteration 
of search algorithm.}

\item{start.tnum}{number of samples to start search 
(this will increase with each step).}

\item{final.tnum}{number of samples for final draw.}

\item{parallel.WY.cores}{number of cores to use for parallel
processing of WY-SD.}

\item{updateProgress}{function to update progress bar (only used
for PUMP shiny app).}

\item{max_sample_size_nbar}{scalar; default upper bound for nbar 
for search algorithm.}

\item{max_sample_size_JK}{scalar; default upper bound for J or K 
for search algorithm.}

\item{tol}{tolerance for target power, defaults to 0.01 (1%).
This parameter controls when the search is done: 
when estimated power (checked with `final.tnum` iterations) 
is within `tol`, the search stops.}

\item{give.optimizer.warnings}{whether to return 
verbose optimizer warnings.}

\item{verbose}{TRUE/FALSE; Print out diagnostics of time, etc.}
}
\value{
a pumpresult object containing sample size results.
}
\description{
The user chooses the context (d_m), MTP,
type of sample size, 
MDES,
power definition, and choices of all relevant design parameters.

The functions performs a search algorithm,
and returns the sample size value within the specified tolerance.
For a list of choices for specific parameters, see pump_info().
}
\examples{
J <- pump_sample(
  d_m = 'd2.1_m2fc',
  MTP = 'HO',
  power.definition = 'D1indiv',
  typesample = 'J',
  target.power = 0.8,
  nbar = 50,
  M = 3,
  MDES = 0.125,
  Tbar = 0.5, alpha = 0.05,
  numCovar.1 = 1,
  R2.1 = 0.1, ICC.2 = 0.05, rho = 0.2,
  tnum = 1000)
}
\seealso{
For more detailed information about this function 
and the user choices,
see the manuscript \url{https://arxiv.org/abs/2112.15273},
which includes a detailed Technical Appendix
including information about the designs and models
and parameters.
}
