% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shapPPwaterfall.R
\name{waterfallplot}
\alias{waterfallplot}
\title{Waterfall plot}
\usage{
waterfallplot(
  PPTreeregOBJ,
  testObs,
  final.rule = 5,
  method = "simple",
  final.leaf = NULL
)
}
\arguments{
\item{PPTreeregOBJ}{PPTreereg class object - a model to be explained}

\item{testObs}{test data observation}

\item{final.rule}{final rule to assign numerical values in the final nodes.
1: mean value in the final nodes
2: median value in the final nodes
3: using optimal projection
4: using all independent variables
5: using several significant independent variables}

\item{method}{simple or empirical method to calculate \code{PPKernelSHAP}}

\item{final.leaf}{location of final leaf}
}
\value{
An object of the class \code{ggplot}
}
\description{
waterfall plot for \code{PPKernelSHAP}
}
\details{
Waterfall plot is mainly used to explain individual predictions,
and is suitable for showing an explanation when a single piece of data is
entered as an input using \code{PPKernelSHAP} values.
}
\examples{
data(dataXY)
testX <- dataXY[1,-1]
Model <- PPTreereg(Y~., data = dataXY, DEPTH = 2)
waterfallplot(Model, testX, final.rule =5, method="simple")


}
