% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mrrTest.R
\name{mrrTest}
\alias{mrrTest}
\alias{mrrTest.default}
\alias{mrrTest.formula}
\title{Madhava Rao-Raghunath Test for Testing Treatment vs. Control}
\usage{
mrrTest(x, ...)

\method{mrrTest}{default}(x, y = NULL, m = NULL, ...)

\method{mrrTest}{formula}(formula, data, subset, na.action, ...)
}
\arguments{
\item{x}{numeric vector of data values. Non-finite (e.g., infinite or missing) values will be omitted.}

\item{\dots}{further arguments to be passed to or from methods.}

\item{y}{an optional numeric vector of data values:
as with x non-finite values will be omitted.}

\item{m}{numeric, optional integer number, whereas \eqn{n = k m} needs to be
full filled.}

\item{formula}{a formula of the form \code{response ~ group} where
\code{response} gives the data values and \code{group} a vector or
factor of the corresponding groups.}

\item{data}{an optional matrix or data frame (or similar: see
\code{\link{model.frame}}) containing the variables in the
formula \code{formula}.  By default the variables are taken from
\code{environment(formula)}.}

\item{subset}{an optional vector specifying a
subset of observations to be used.}

\item{na.action}{a function which indicates what should happen when
the data contain \code{NA}s.  Defaults to \code{getOption("na.action")}.}
}
\value{
A list with class \code{"htest"} containing the following components:
\describe{
\item{method}{a character string indicating what type of test was performed.}
\item{data.name}{a character string giving the name(s) of the data.}
\item{statistic}{the estimated quantile of the test statistic.}
\item{p.value}{the p-value for the test.}
\item{parameter}{the parameters of the test statistic, if any.}
\item{alternative}{a character string describing the alternative hypothesis.}
\item{estimates}{the estimates, if any.}
\item{null.value}{the estimate under the null hypothesis, if any.}
}
}
\description{
The function has implemented the nonparametric test of
Madhava Rao and Raghunath (2016) for testing paired two-samples
for symmetry. The null hypothesis \eqn{H: F(x,y) = F(y,x)}
is tested against the alternative \eqn{A: F(x,y) \ne F(y,x)}{A: F(x,y) != F(y,x)}.
}
\details{
Let \eqn{X_i} and \eqn{Y_i, ~ i \le n} denote
continuous variables that were observed
on the same \eqn{i}th test item (e.g. patient)
with \eqn{i = 1, \ldots n}. Let
\deqn{
  U_i = X_i + Y_i \qquad V_i = X_i - Y_i
}{%
 SEE PDF
}

Let \eqn{U_{(i)}} be the \eqn{i}th order statistic,
\eqn{U_{(1)} \le U_{(2)} \le \ldots U_{(n)}} and \eqn{k} the
number of clusters, with the condition:

\deqn{
 n = k ~ m.
}{%
 SEE PDF
}

Further, let the divider denote \eqn{d_0 = -\infty}, \eqn{d_k = \infty}, and else
\deqn{
 d_j = \frac{ U_{(jm)} +  U_{(jm+1)} }{2}, ~ 1 \le j \le k -1
}{%
 SEE PDF
}

The two counts are
\deqn{
 n_j^{+} = \left\{
           \begin{array}{lr}
           1 & \mathrm{if}~ d_{j-1} < u_i < d_j, v_i > 0 \\
           0 &
           \end{array}
           \right.
}{%
 SEE PDF
}

and
\deqn{
 n_j^{-} = \left\{
           \begin{array}{lr}
           1 & \mathrm{if}~ d_{j-1} < u_i < d_j, v_i \le 0 \\
           0 &
           \end{array}
           \right.
}{%
 SEE PDF
}

The test statistic is
\deqn{
 M = \sum_{j = 1}^k \frac{\left(n_j^{+} - n_j^{-}\right)^2}
                         {m}
}{%
 SEE PDF
}

The exact p-values for \eqn{5 \le n \le 30} are taken from an
internal look-up table. The exact p-values were taken
from Table 7, Appendix B  of Madhava Rao and Raghunath (2016).

If \code{m = NULL} the function uses \eqn{n = m} for
all prime numbers, otherwise it tries to find an value for
m in such a way, that for \eqn{k = n / m} all variables
are integer.
}
\note{
The function returns an error code if a value for \code{m}
is provided  that does not lead to an integer of the ratio
\eqn{k = n /m}.

The function also returns an error code, if a tabulated
value for given \eqn{n}, \eqn{m} and calculated \eqn{M}
can not be found in the look-up table.
}
\examples{
## Madhava Rao and Raghunath (2016), p. 151
## Inulin clearance of living donors
## and recipients of their kidneys
x <- c(61.4, 63.3, 63.7, 80.0, 77.3, 84.0, 105.0)
y <- c(70.8, 89.2, 65.8, 67.1, 87.3, 85.1, 88.1)
mrrTest(x, y)

## formula method
## Student's Sleep Data
mrrTest(extra ~ group, data = sleep)

}
\references{
Madhava Rao, K.S., Ragunath, M. (2016) A Simple Nonparametric Test
for Testing Treatment Versus Control. \emph{J Stat Adv Theory Appl} \bold{16},
133–162. \doi{10.18642/jsata_7100121717}
}
\keyword{htest}
