% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shirleyWilliamsTest.R
\name{shirleyWilliamsTest}
\alias{shirleyWilliamsTest}
\alias{shirleyWilliamsTest.default}
\alias{shirleyWilliamsTest.formula}
\title{Shirley-Williams Test}
\usage{
shirleyWilliamsTest(x, ...)

\method{shirleyWilliamsTest}{default}(
  x,
  g,
  alternative = c("two.sided", "greater", "less"),
  method = c("look-up", "boot"),
  nperm = 10000,
  ...
)

\method{shirleyWilliamsTest}{formula}(
  formula,
  data,
  subset,
  na.action,
  alternative = c("two.sided", "greater", "less"),
  method = c("look-up", "boot"),
  nperm = 10000,
  ...
)
}
\arguments{
\item{x}{a numeric vector of data values, or a list of numeric data
vectors.}

\item{\dots}{further arguments to be passed to or from methods.}

\item{g}{a vector or factor object giving the group for the
corresponding elements of \code{"x"}.
Ignored with a warning if \code{"x"} is a list.}

\item{alternative}{the alternative hypothesis. Defaults to \code{two.sided}}

\item{method}{a character string specifying the test statistic to use.
Defaults to \code{"look-up"} that uses published Table values of Williams (1972).}

\item{nperm}{number of permutations for the asymptotic permutation test.
Defaults to \code{1000}. Ignored, if \code{method = "look-up"}.}

\item{formula}{a formula of the form \code{response ~ group} where
\code{response} gives the data values and \code{group} a vector or
factor of the corresponding groups.}

\item{data}{an optional matrix or data frame (or similar: see
\code{\link{model.frame}}) containing the variables in the
formula \code{formula}.  By default the variables are taken from
\code{environment(formula)}.}

\item{subset}{an optional vector specifying a 
subset of observations to be used.}

\item{na.action}{a function which indicates what should happen when
the data contain \code{NA}s.  Defaults to \code{getOption("na.action")}.}
}
\value{
Either a list with class \code{"osrt"} or a list with class \code{"PMCMR"}.

\describe{
 \item{method}{a character string indicating what type of test was performed.}
 \item{data.name}{a character string giving the name(s) of the data.}
 \item{statistic}{the estimated statistic(s)}
 \item{crit.value}{critical values for \eqn{\alpha = 0.05}.}
 \item{alternative}{a character string describing the alternative hypothesis.}
 \item{parameter}{the parameter(s) of the test distribution.}
\item{dist}{a string that denotes the test distribution.}
}
There are print and summary methods available.

A list with class \code{"PMCMR"} containing the following components:
\describe{
 \item{method}{a character string indicating what type of test was performed.}
 \item{data.name}{a character string giving the name(s) of the data.}
 \item{statistic}{lower-triangle matrix of the estimated
quantiles of the pairwise test statistics.}
 \item{p.value}{lower-triangle matrix of the p-values for the pairwise tests.}
 \item{alternative}{a character string describing the alternative hypothesis.}
\item{p.adjust.method}{a character string describing the method for p-value
adjustment.}
\item{model}{a data frame of the input data.}
\item{dist}{a string that denotes the test distribution.}
}
}
\description{
Performs Shirley's nonparametric equivalent of William's test
for contrasting increasing dose levels of a treatment.
}
\details{
The Shirley-William test is a non-parametric step-down trend test for testing several treatment levels
with a zero control. Let there be \eqn{k} groups including the control and let
the zero dose level be indicated with \eqn{i = 0} and the highest
dose level with \eqn{i = m}, then the following \code{m = k - 1} hypotheses are tested:

\deqn{
\begin{array}{ll}
\mathrm{H}_{m}: \theta_0 = \theta_1 = \ldots = \theta_m, & \mathrm{A}_{m} = \theta_0 \le \theta_1 \le \ldots \theta_m, \theta_0 < \theta_m \\
\mathrm{H}_{m-1}: \theta_0 = \theta_1 = \ldots = \theta_{m-1}, & \mathrm{A}_{m-1} = \theta_0 \le \theta_1 \le \ldots \theta_{m-1}, \theta_0 < \theta_{m-1} \\
\vdots & \vdots \\
\mathrm{H}_{1}: \theta_0 = \theta_1, & \mathrm{A}_{1} = \theta_0 < \theta_1\\
\end{array}
}

Let \eqn{R_{ij}} be the rank of \eqn{X_{ij}},
where \eqn{X_{ij}} is jointly ranked
from \eqn{\left\{1, 2, \ldots, N \right\}, ~~ N = \sum_{i=1}^k n_i},
then the test statistic is

\deqn{
  t_{i} = \frac{\max_{1 \le u \le i} \left(\sum_{j=u}^i n_j \bar{R}_j / \sum_{j=u}^i n_j \right) - \bar{R}_0}
{\sigma_{R_i} \sqrt{1/n_i + 1/n_0}},
}{%
 SEE PDF
}

with expected variance of
\deqn{
\sigma_{R_i}^2 = N_i \left(N_i + 1 \right) / 12 - T_i,
}{%
 SEE PDF
}

where \eqn{N_i = n_0 + n_1 + n_2 + \ldots + n_i} and
\eqn{T_i} the ties for the \eqn{i}-th comparison is given by

\deqn{
 T_i = \sum_{j=1}^i \frac{t_j^3 - t_j}{12 \left(N_i - 1\right)}.
}{%
 SEE PDF
}

The procedure starts from the highest dose level (\eqn{m}) to the the lowest dose level (\eqn{1}) and
stops at the first non-significant test. The consequent lowest effect dose
is the treatment level of the previous test number. This function has
included the modifications as recommended by Williams (1986), i.e.
the data are re-ranked for each of the \eqn{i}-th comparison.

If \code{method = "look-up"} is selected, the function does not return p-values.
Instead the critical \eqn{t'_{i,v,\alpha}}-values
as given in the tables of Williams (1972) for \eqn{\alpha = 0.05} (one-sided)
are looked up according to the degree of freedoms (\eqn{v = \infty}) and the order number of the
dose level (\eqn{i}) and (potentially) modified according to the given extrapolation
coefficient \eqn{\beta}.

Non tabulated values are linearly interpolated with the function
\code{\link[stats]{approx}}.

For the comparison of the first dose level (i = 1) with the control, the critical
z-value from the standard normal distribution is used (\code{\link[stats]{Normal}}).

If \code{method = "boot"}, the p-values are estimated through an assymptotic
boot-strap method. The p-values for H\eqn{_1}
are calculated from the t distribution with infinite degree of freedom.
}
\note{
For \code{method = "look-up"}, only tests on the level of \eqn{\alpha = 0.05}
can be performed for alternative hypotheses less or greater.

For \code{method = "boot"} only the alternative \code{"two.sided"} can be calculated.
One may increase the number of permutations to e.g. \code{nperm = 10000}
in order to get more precise p-values. However, this will be on the expense of
computational time.
}
\examples{
## Example from Shirley (1977)
## Reaction times of mice to stimuli to their tails.
x <- c(2.4, 3, 3, 2.2, 2.2, 2.2, 2.2, 2.8, 2, 3,
 2.8, 2.2, 3.8, 9.4, 8.4, 3, 3.2, 4.4, 3.2, 7.4, 9.8, 3.2, 5.8,
 7.8, 2.6, 2.2, 6.2, 9.4, 7.8, 3.4, 7, 9.8, 9.4, 8.8, 8.8, 3.4,
 9, 8.4, 2.4, 7.8)
g <- gl(4, 10)

## Shirley's test
## one-sided test using look-up table
shirleyWilliamsTest(x ~ g, alternative = "greater")

## Chacko's global hypothesis test for 'greater'
chackoTest(x , g)

## post-hoc test, default is standard normal distribution (NPT'-test)
summary(chaAllPairsNashimotoTest(x, g, p.adjust.method = "none"))

## same but h-distribution (NPY'-test)
chaAllPairsNashimotoTest(x, g, dist = "h")

## NPM-test
NPMTest(x, g)

## Hayter-Stone test
hayterStoneTest(x, g)

## all-pairs comparisons
hsAllPairsTest(x, g)
}
\references{
Shirley, E., (1977) Nonparametric Equivalent of Williams Test for Contrasting Increasing
Dose Levels of a Treatment, \emph{Biometrics} \bold{33}, 386--389.

Williams, D. A. (1986) Note on Shirley's nonparametric test for comparing
several dose levels with a zero-dose control, \emph{Biometrics} \bold{42}, 183--186.
}
\seealso{
\code{\link{williamsTest}}
}
\concept{trendtest}
\keyword{htest}
\keyword{nonparametric}
