#' @title Calculates the risk score for patients
#' @description The function `get_risk_score` uses to calculate the risk score for patients based on cancer-specific dysregulated signaling pathways.
#' @param final_signature Cancer-specific dysregulated signal pathways. It can be generated by the function `get_final_signature`.
#' @param pfs_score A matrix that contains the pfs_score in each sample of the signal pathways. Noted the matrix can be generated by the function `get_pfs_score`.
#' @param sur This data contains survival status and survival time of each sample.
#' @param path_Ucox_mul_res Results of multivariate Cox regression of cancer specific pathway in training set.
#' @param TRAIN Logical,if set FLASE,we need to load the result of multivariate Cox regression of cancer specific pathways into the training set.
#' @importFrom survival coxph
#' @return A data set with the risk score for each sample.
#' @export
#' @examples
#' #Load the data.
#' data(final_signature,pfs_score,sur,path_Ucox_mul_res)
#' #perform the function `get_risk_score`.
#' km_data<-get_risk_score(final_signature,pfs_score,path_Ucox_mul_res,sur,TRAIN=TRUE)



get_risk_score<-function(final_signature,pfs_score,path_Ucox_mul_res,sur,TRAIN=TRUE){
  pfs_score<-t(pfs_score)
  pfs_score<-pfs_score[,match(final_signature,colnames(pfs_score))]
  lo<-match(rownames(pfs_score),rownames(sur))
  DE_path_sur<-cbind(pfs_score,sur[lo,1:2])
  colnames(DE_path_sur)<-c(colnames(DE_path_sur)[1:(length(colnames(DE_path_sur))-2)],"event","survival")
  if(TRAIN){
    path_name<-cbind(colnames(DE_path_sur),paste0("a",1:length(colnames(DE_path_sur))))
    DE_path_sur1<-DE_path_sur
    colnames(DE_path_sur1)[1:(dim(DE_path_sur1)[2]-2)]<-path_name[1:(dim(path_name)[1]-2),2]
    Ucox_mul_res<-get_MultivariateCox_result(DE_path_sur1)
    rownames(Ucox_mul_res)<-path_name[match(rownames(Ucox_mul_res),path_name[,2]),1]
  }else{
    Ucox_mul_res<-path_Ucox_mul_res
  }
  newdata<-matrix(data=0,nrow=dim(DE_path_sur)[1],ncol=1)
  colnames(newdata)<-"multiple_score"
  res<-cbind(DE_path_sur,newdata)
  num<-dim(res)[2]-3
  for(j in 1:dim(res)[1]){
    score<-0
    for(k in 1:num){
      score<-score+res[j,k]*-Ucox_mul_res[match(names(res[j,])[k],rownames(Ucox_mul_res)),1]
    }
    res[j,dim(res)[2]]<-score
  }
  return((res))}
