% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mortality.R
\name{mortality}
\alias{mortality}
\title{Calculating starvation related mortality of \emph{Thaumetopoea processionea}}
\usage{
mortality(
  x,
  par_budswelling = "quercus_robur_clone256_type1",
  par_hatch = c("custers", "wagenhoff", "meurisse"),
  def_hatch = "first",
  last = TRUE
)
}
\arguments{
\item{x}{SpatRaster list (tmean, tmax, tmin) - numeric - with time attribute}

\item{par_budswelling}{character - parametrisation for bud swelling}

\item{par_hatch}{character - parametrisation for hatch}

\item{def_hatch}{definition of hatch - character - either "first" or "mean"}

\item{last}{If TRUE returns only the result for the last day. last row/layer for data.frame/SpatRaster}
}
\value{
SpatRaster with mortality in \%.
}
\description{
Calculating the starvation-related mortality rate of L1 larvae, dependent on degree days from the first hatch to feeding start (bud swelling of the host tree \emph{Quercus robur}).
All already available parameter settings can be shown with parameter().
}
\examples{
\donttest{
srl <- load_test()
mortality(srl)
}
}
\seealso{
Other Main: 
\code{\link{get_legend}()},
\code{\link{parameter}()},
\code{\link{phenology}()},
\code{\link{phenthau}()}
}
\concept{Main}
