% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/squishList.R
\name{squishList}
\alias{squishList}
\title{Compress a List by Name}
\usage{
squishList(myList, unique = FALSE)
}
\arguments{
\item{myList}{a list with named elements to be compressed}

\item{unique}{logical flag to try and reduce result to only unique values}
}
\value{
a list with one element for every unique name in the original list
}
\description{
Attempts to compress a list by combining elements with
  the same name, searching recursively if there are lists in your
  list
}
\details{
items with the same name are assumed to have the same structure
  and will be combined. Dataframes will be combined with bind_rows, vectors
  just be collapsed into one vector, matrices will be combined with rbind,
  lists will be combined recursively with another call to \code{squishList}
}
\examples{

myList <- list(a=1:3, b=letters[1:4], a=5:6, b=letters[4:10])
squishList(myList)

myList <- list(a=1:3, b=data.frame(x=1:3, y=4:6), b=data.frame(x=10:14, y=1:5))
squishList(myList)

myList <- list(a=list(c=1:2, d=2), b=letters[1:3], a=list(c=4:5, d=6:9))
squishList(myList)

}
\author{
Taiki Sakai \email{taiki.sakai@noaa.gov}
}
