% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prior_distribution.R
\name{runiform_ball}
\alias{runiform_ball}
\title{Multivariate Uniform Distribution on a ball}
\usage{
runiform_ball(n, d, R)
}
\arguments{
\item{n}{number of desired samples.}

\item{d}{positive integer, representing the dimension of the observations.}

\item{R}{positive real value, the radius of the ball in \strong{R}^{d}.}
}
\value{
a matrix of \code{n} samples of length d.
}
\description{
This function generates random samples from multivariate uniform distribution on a ball in \strong{R}^{d}, equipped with \eqn{L^{2}} norm (\emph{i.e.,} Euclidean distance), centered in \strong{0}, with radius R.
}
\details{
This function generates samples from the multivariate uniform distribution whose density is \deqn{\pi(c, R) = \Gamma(d/2 + 1)/ \pi^{d/2} * 1/(R)^{d} 1_{B_{d}(R)}(c),} where \eqn{1_{B_{d}(R)}} is a centered \eqn{L^{2}} ball with radius R.
}
\examples{
##generating 10000 samples from uniform distribution on a unit ball in \\strong{R}^{2}
result <- runiform_ball(10000, 2, 1)
plot(result)
}

