% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loss_functions.R
\name{instantaneous_loss}
\alias{instantaneous_loss}
\title{Instantaneous Loss}
\usage{
instantaneous_loss(centers, instant_observation)
}
\arguments{
\item{centers}{a matrix containing m centers of length d, where each row corresponds to d coordinates of a center.}

\item{instant_observation}{a vector of length d.}
}
\value{
The squared Euclidean distance of \code{instant_observation} to its nearest center within \code{centers}.
}
\description{
This function computes the instantaneous loss (\emph{i.e.,} squared Euclidean distantce) of an observation to its nearest center within a set of centers.
}
\details{
Given a set \emph{C} of m centers of length d (\emph{i.e.,} \emph{C} = \eqn{{c_{1}, c_{2}, \dots, c_{m}}}) and a vector observation x of length d, this function computes the squared euclidean distance of x to its nearest center within \emph{C}, \emph{i.e.,} \deqn{L(x,C) = min_{1<= i <= m}|x-c_{i}|_{2}^{2}.}
}
\examples{
## generating 4 centers of length 3.
centers <- matrix(1:12, nrow = 4, ncol = 3)
instant_observation <- c(2,6,10)
instantaneous_loss(centers, instant_observation)
}
\keyword{internal}

