% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/conditional_probability_functions.R
\name{conditional_mean}
\alias{conditional_mean}
\title{Calculate the conditional mean of a multivariate normal distribution}
\usage{
conditional_mean(x_a, mu_a, mu_b, Sigma)
}
\arguments{
\item{x_a}{(Observed) first part of normally distributed vector.}

\item{mu_a}{Mean of second part of normally distributed vector.}

\item{mu_b}{Mean of first part of normally distributed vector.}

\item{Sigma}{covariance matrix of test statistic vector c(Z_TP1, Z_TP2, Z_TC1, Z_TC2).}
}
\value{
numeric vector with the conditional mean
}
\description{
See e.g. Chapter 8.1.2 in \href{https://www.math.uwaterloo.ca/~hwolkowi/matrixcookbook.pdf}{The Matrix Cookbook}.
}
\references{
Petersen, K. B., & Pedersen, M. S. (2008). The matrix cookbook. Technical University of Denmark, 7(15), 510.
}
