% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OptimLMM.R
\name{Optim.LMM}
\alias{Optim.LMM}
\title{Discover what is the best random variable for your data set}
\usage{
Optim.LMM(response, data, randomatributtecandidate = NULL, ...)
}
\arguments{
\item{response}{A character object that contain the name of response variable about which a researcher is asking a question. \code{"Y"}}

\item{data}{Data frame from which variables specified in  \code{formula} are preferentially to be taken.}

\item{randomatributtecandidate}{a character vector, or \code{NULL}. The default value is \code{NULL},the function tests with all those categorical variables in the data. The default option is nor recommended. Because the decision must be made according to the objective of statistical modeling. But it can serve as orientation.}

\item{...}{arguments passed to \code{\link[lme4]{lmer}}}
}
\value{
For \code{Optim.LMM}, an object of  \code{"Optim"}. Items of interest in 3 the output are:
  \item{Models }{a data.frame to summary all models tested}
  \item{Model }{a list of the models generated from  \code{\link[lme4]{lmer}}}
  \item{ }{A data.frame whose content summarize the different models generated}
}
\description{
This function allows to find best \code{LMM} for a specific data.
}
\examples{
if(interactive()){
## Load a Dataset
data(AustralianCredit)
## Generate a model
modelFit <- Optim.LMM("Y", AustralianCredit, p = 0.7, seed=2018)
modelFit
}

}
