% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OptimDA.R
\name{Optim.DA}
\alias{Optim.DA}
\title{Discover the best Discriminant Analysis for your data}
\usage{
Optim.DA(formula, data, p, criteria = c("rmse", "success", "errorti",
  "errortii"), seed = NULL, ...)
}
\arguments{
\item{formula}{A formula of the form \code{y ~ x1 + x2 + \dots}}

\item{data}{Data frame from which variables specified in  \code{formula} are preferentially to be taken.}

\item{p}{A percentage of training elements}

\item{criteria}{Select criterion to use.}

\item{seed}{a single value, interpreted as an integer, or \code{NULL}. The default value is \code{NULL}, but for future checks of the model or models generated it is advisable to set a random seed to be able to reproduce it.}

\item{...}{arguments passed to \code{\link[MASS]{lda}} and \code{\link[MASS]{qda}}}
}
\value{
An object of class \code{Optim}. See\code{\link{Optim.object}}
}
\description{
This function search the best Discriminant Analysis (DA) between \code{LDA} and \code{QDA}.
}
\details{
LDA and QDA are distribution-based classifiers with the assumption that data follows
a multivariate normal distribution.
LDA differs from QDA in the assumption about the class variability. LDA assumes that all classes share the same within-class covariance matrix whereas QDA allows for distinct within-class covariance matrices.
}
\examples{
if(interactive()){
## Load a Dataset
data(AustralianCredit)
## Generate a Model
modelFit <- Optim.DA(Y~., SpanishCredit, p = 0.7, seed=2018)
modelFit
}

}
