% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_opus.R
\name{read_opus}
\alias{read_opus}
\title{Read spectral data from Bruker OPUS binary files}
\usage{
read_opus(
  file,
  share = NULL,
  metadata = list(file_name = basename(file), user_name = NULL, contact_info = NULL,
    organization = NULL, citation = NULL, spectrum_type = NULL, spectrum_identity = NULL,
    material_form = NULL, material_phase = NULL, material_producer = NULL,
    material_purity = NULL, material_quality = NULL, material_color = NULL,
    material_other = NULL, cas_number = NULL, instrument_used = NULL,
    instrument_accessories = NULL, instrument_mode = NULL, spectral_resolution = NULL,
    laser_light_used = NULL, number_of_accumulations = NULL, 
    
    total_acquisition_time_s = NULL, data_processing_procedure = NULL,
    level_of_confidence_in_identification = NULL, other_info = NULL, license =
    "CC BY-NC"),
  type = "spec",
  digits = 1L,
  atm_comp_minus4offset = FALSE
)
}
\arguments{
\item{file}{character vector with path to file(s).}

\item{share}{defaults to \code{NULL}; needed to share spectra with the
Open Specy community; see \code{\link{share_spec}()} for details.}

\item{metadata}{a named list of the metadata; see
\code{\link{as_OpenSpecy}()} for details.}

\item{type}{character vector of spectra types to extract from OPUS binary
file. Default is \code{"spec"}, which will extract the final spectra, e.g.
expressed in absorbance (named \code{AB} in Bruker OPUS programs). Possible
additional values for the character vector supplied to \code{type} are
\code{"spec_no_atm_comp"} (spectrum of the sample without compensation for
atmospheric gases, water vapor and/or carbon dioxide),
\code{"sc_sample"} (single channel spectrum of the sample measurement), \code{"sc_ref"}
(single channel spectrum of the reference measurement),
\code{"ig_sample"} (interferogram of the sample measurement) and \code{"ig_ref"}
(interferogram of the reference measurement).}

\item{digits}{Integer that specifies the number of decimal places used to
round the wavenumbers (values of x-variables).}

\item{atm_comp_minus4offset}{Logical whether spectra after atmospheric
compensation are read with an offset of -4 bytes from Bruker OPUS files;
default is \code{FALSE}.}
}
\value{
An \code{OpenSpecy} object.
}
\description{
Read file(s) acquired with a Bruker Vertex FTIR Instrument. This function
is basically a fork of \code{opus_read()} from
\url{https://github.com/pierreroudier/opusreader}.
}
\details{
The type of spectra returned by the function when using
\code{type = "spec"} depends on the setting of the Bruker instrument: typically,
it can be either absorbance or reflectance.

The type of spectra to extract from the file can also use Bruker's OPUS
software naming conventions, as follows:
\itemize{
\item \code{ScSm} corresponds to \code{sc_sample}
\item \code{ScRf} corresponds to \code{sc_ref}
\item \code{IgSm} corresponds to \code{ig_sample}
\item \code{IgRf} corresponds to \code{ig_ref}
}
}
\examples{
read_extdata("ftir_ps.0") |> read_opus()

}
\seealso{
\code{\link{read_spec}()} for reading .y(a)ml, .json, or .rds (OpenSpecy)
files;
\code{\link{read_text}()}, \code{\link{read_asp}()}, \code{\link{read_spa}()},
\code{\link{read_spc}()}, and \code{\link{read_jdx}()} for text files, .asp,
.spa, .spa, .spc, and .jdx formats, respectively;
\code{\link{read_text}()} for reading .dat (ENVI) files;
\code{\link{read_zip}()} and \code{\link{read_any}()} for wrapper functions;
\code{\link{read_opus_raw}()};
}
\author{
Philipp Baumann, Zacharias Steinmetz, Win Cowger
}
