% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/open_image_rscript.R
\name{rotateFixed}
\alias{rotateFixed}
\title{Rotate an image by 90, 180, 270 degrees}
\usage{
rotateFixed(image, angle)
}
\arguments{
\item{image}{matrix, data frame or 3-dimensional array}

\item{angle}{one of 90, 180 and 270 radians}
}
\value{
depending on the input, either a matrix or an array
}
\description{
Rotate an image by 90, 180, 270 degrees
}
\details{
This function is faster than the rotateImage function as it rotates an image for specific angles (90, 180 or 270 radians).
}
\examples{

path = system.file("tmp_images", "3.jpeg", package = "OpenImageR")

image = readImage(path)

r = rotateFixed(image, 90)

}

