% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zzz.R
\name{setSimonParams}
\alias{setSimonParams}
\title{Sets the parameters for a given "simon"-object.}
\usage{
setSimonParams(s, alpha = 0.05, beta = 0.05, p0 = 0.1, p1 = 0.3)
}
\arguments{
\item{s}{a "simon"-object which is generated by the function \code{\link{setupSimon}}.}

\item{alpha}{the maximal type I error rate.}

\item{beta}{the maximal type II error rate.}

\item{p0}{the response probability under the null hypothesis.}

\item{p1}{the response probability under the alternative hypothesis.}
}
\description{
Sets the parameters for a given "simon"-object.
}
\examples{
\dontrun{
#Create "simon"-object.
simon <- setupSimon()
#Change parameters.
setSimonParams(simon, alpha = 0.1, beta = 0.2, p0 = 0.25, p1 = 0.45)
#Calculate designs for the given "simon"-object.
designs <- getSolutions(simon)$Solutions
designs
}
}
\seealso{
\code{\link{setupSimon}}
}

