% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotObservationPeriod.R
\name{plotObservationPeriod}
\alias{plotObservationPeriod}
\title{Create a plot from the output of summariseObservationPeriod().}
\usage{
plotObservationPeriod(
  result,
  variableName = "number subjects",
  plotType = "barplot",
  facet = "cdm_name"
)
}
\arguments{
\item{result}{A summarised_result object.}

\item{variableName}{The variable to plot it can be: "number subjects",
"records per person", "duration" or "days to next observation period".}

\item{plotType}{The plot type, it can be: "barplot", "boxplot" or
"densityplot".}

\item{facet}{Elements to facet by, it can be "cdm_name",
"observation_period_ordinal", both or none.}
}
\value{
A ggplot2 object.
}
\description{
Create a plot from the output of summariseObservationPeriod().
}
\examples{
\donttest{
cdm <- mockOmopSketch(numberIndividuals = 100)

result <- summariseObservationPeriod(cdm$observation_period)

result |>
  plotObservationPeriod(
    variableName = "duration in days",
    plotType = "boxplot"
  )

PatientProfiles::mockDisconnect(cdm)
}
}
