#' @title class_summary

#' @description class_summary function provides information on main protein classes. Barplot also helps to visualise  the class distribution. Function depends on  the data frame generated by score_genes function,
#' @param data Requires a  data frame generated by score_genes; class - data frame
#' @return  multiple plots; class - plots
#' @importFrom RCurl getURL
#' @importFrom ggplot2 aes
#' @importFrom ggplot2 theme
#' @ImpportFrom ggplot2 element_text
#' @ImportFrom ggplot2 geom_col
#' @ImportFrom ggplot2 ggplot
#' @import methods
#' @import utils
#' @examples
#' \dontrun{
#' path_to_test_data<- system.file("extdata", "test_data.tabular", package="OmicInt")
#' # basic usage of class_summary
#' df<-utils::read.table(path_to_test_data)
#' class_summary(df)}
#' @export
class_summary<-function(data){

  #plot structures
  #access data
  classes_url <- RCurl::getURL("https://gitlab.com/Algorithm379/databases/-/raw/main/HS_protein_classes_curated.csv")
  classes <- utils::read.csv(text = classes_url)

  #prepare data frame
  data$"Class"<-ifelse(data$"Symbol"%in%classes$"Gene",classes$"Class","NA")
  #extract features
  df<-table(data$"Class")
  df<-as.data.frame(sort(df,decreasing = TRUE))
  colnames(df)<-c("Class","Freq")
  print(df)

  # to avoid conflicts and warning messages
  Class<-df$"Class"
  Freq<-df$"Freq"

  p1<-ggplot2::ggplot(df)+ggplot2::geom_col(ggplot2::aes(x=Class,y=Freq, fill=Class))+ggplot2::theme(axis.text.x = ggplot2::element_text(angle = 90, vjust = 0.5, hjust=1))
  methods::show(p1)


}
