% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Olink_ttest.R
\name{olink_ttest}
\alias{olink_ttest}
\title{Function which performs a t-test per protein}
\usage{
olink_ttest(df, variable, pair_id, ...)
}
\arguments{
\item{df}{NPX data frame in long format with at least protein name (Assay), OlinkID, UniProt and a factor with 2 levels.}

\item{variable}{Character value indicating which column should be used as the grouping variable. Needs to have exactly 2 levels.}

\item{pair_id}{Character value indicating which column indicates the paired sample identifier.}

\item{...}{Options to be passed to t.test. See \code{?t.test} for more information.}
}
\value{
A "tibble" containing the t-test results for every protein.
Columns include:
\itemize{
\item{Assay:} "character" Protein symbol
\item{OlinkID:} "character" Olink specific ID
\item{UniProt:} "character" UniProt ID
\item{Panel:} "character" Name of Olink Panel
\item{estimate:} "numeric" difference in mean NPX between groups
\item{Group 1:} "numeric" Column is named first level of variable when converted to factor, contains mean NPX for that group
\item{Group 2:} "numeric" Column is named second level of variable when converted to factor, contains mean NPX for that group
\item{statistic:} "named numeric" value of the t-statistic
\item{p.value:} "numeric" p-value for the test
\item{parameter:} "named numeric" degrees of freedom for the t-statistic
\item{conf.low:} "numeric" confidence interval for the mean (lower end)
\item{conf.high:} "numeric" confidence interval for the mean (upper end)
\item{method:} "character" which t-test method was used
\item{alternative:} "character" describes the alternative hypothesis
\item{Adjusted_pval:} "numeric" adjusted p-value for the test (Benjamini&Hochberg)
\item{Threshold:} "character" if adjusted p-value is significant or not (< 0.05)
}
}
\description{
Performs a Welch 2-sample t-test or paired t-test at confidence level 0.95 for every protein (by OlinkID)
for a given grouping variable using stats::t.test and corrects for multiple testing by
the Benjamini-Hochberg method (“fdr”) using stats::p.adjust.
Adjusted p-values are logically evaluated towards adjusted p-value<0.05.
The resulting t-test table is arranged by ascending p-values.
}
\examples{
\donttest{

library(dplyr)

npx_df <- npx_data1 \%>\% filter(!grepl('control',SampleID, ignore.case = TRUE))

ttest_results <- olink_ttest(df=npx_df,
                             variable = 'Treatment',
                             alternative = 'two.sided')

#Paired t-test
npx_df \%>\%
   filter(Time \%in\% c("Baseline","Week.6")) \%>\%
   olink_ttest(variable = "Time", pair_id = "Subject")
}
}
