% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opl_dt_c.R
\name{opl_dt_c}
\alias{opl_dt_c}
\title{Optimal Policy Learning with Decision Tree}
\usage{
opl_dt_c(make_cate_result, z, w, c1 = NA, c2 = NA, c3 = NA, verbose = TRUE)
}
\arguments{
\item{make_cate_result}{A data frame resulting from the \code{make_cate} function, containing the predicted treatment effects (\code{my_cate}) and other variables for treatment assignment.}

\item{z}{A character vector containing the names of the variables used for treatment assignment.}

\item{w}{A string representing the treatment indicator variable name.}

\item{c1}{Value of the threshold value c1 for the first splitting variable. This number must be chosen between 0 and 1.}

\item{c2}{Value of the threshold value c2 for the second splitting variable. This number must be chosen between 0 and 1.}

\item{c3}{Value of the threshold value c3 for the third splitting variable. This number must be chosen between 0 and 1.}

\item{verbose}{Set TRUE to print the output on the console.}
}
\value{
A list containing:
\itemize{
\item \code{W_opt_constr}: The maximum average constrained welfare.
\item \code{W_opt_unconstr}: The average unconstrained welfare.
\item \code{units_to_be_treated}: A data frame of the units to be treated based on the optimal policy.
\item A plot showing the optimal policy assignment.
}
}
\description{
Implementing ex-ante treatment assignment using as policy class a 2-layer fixed-depth decision-tree at specific splitting variables and threshold values.
}
\references{
\itemize{
\item Athey, S., and Wager S. 2021. Policy Learning with Observational Data, Econometrica, 89, 1, 133–161.
\item Cerulli, G. 2021. Improving econometric prediction by machine learning, Applied Economics Letters, 28, 16, 1419-1425.
\item Cerulli, G. 2022. Optimal treatment assignment of a threshold-based policy: empirical protocol and related issues, Applied Economics Letters, DOI: 10.1080/13504851.2022.2032577.
\item Gareth, J., Witten, D., Hastie, D.T., Tibshirani, R. 2013. An Introduction to Statistical Learning : with Applications in R. New York, Springer.
\item Kitagawa, T., and A. Tetenov. 2018. Who Should Be Treated? Empirical Welfare Maximization Methods for Treatment Choice, Econometrica, 86, 2, 591–616.
}
}
