% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prepare_census_tables.R
\name{prepare_census_tables}
\alias{prepare_census_tables}
\title{Prepare Census Tables}
\usage{
prepare_census_tables(input_path, output_path, write_output = FALSE)
}
\arguments{
\item{input_path}{Path to directory containing input CSV files}

\item{output_path}{Path to output directory for Excel files}

\item{write_output}{Logical, indicating whether or not to write the output to file (default: FALSE)}
}
\value{
If write_to_file is TRUE, a list of file paths for the Excel filesw will be produced.
}
\description{
This function takes a path to a directory containing CSV files of census data tables, and
a path to an output directory. It cleans the data tables and exports them as Excel files
to the output directory.
}
\examples{
temp_dir <- tempdir()
file_path <- paste0(temp_dir, "/", "outputs/")
prepare_census_tables(system.file("extdata/census_data",
 package = "OHCSpackage"), file_path, write_output = TRUE)

}
