% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/createJacobian.R
\name{createJacobian}
\alias{createJacobian}
\title{Create Jacobian matrix for the parameters of the ODE.}
\usage{
createJacobian(odenet, ParamVec = NA)
}
\arguments{
\item{odenet}{[\code{ODEnetwork}]\cr
List of class \code{\link{ODEnetwork}}.}

\item{ParamVec}{[\code{vector}] of length n\cr
Named vector to overwrite corresponding parameters (see \code{\link{updateOscillators}}).
Masses start with "m." followed by a number (e.g.: "m.12").
Dampers start with "d." followed by one or two numbers separated by a dot (e.g.: "d.2", "d.5.6").
Springs start with "k.", like dampers (e.g.: "k.4", "k.3.9").
The triangle elements of the dampers and springs are characterised by increasing numbers.
A name "d.3.5" is correct, in contrast to "d.5.3" which is ignored.
This is done to speed up, because the matrices are symmetric.
State1 and state2 start with "st1." or "st2." respectively, followed by a number (e.g.: "st1.15", "st2.8").
If the vector is set, the following parameters are ignored.}
}
\value{
the Jacobian matrix of size 2n*4n.
}
\description{
Creates the Jacobian matrix for a special set of parameters of the ODE.
The first n columns contain the derivatives with respect to d_ii, 
followed by the derivatives with respect to k_ii.
The last 2*n columns include the derivatives with respect to the states.
}
\examples{
masses <- 4:6
dampers <- diag(1:3)
springs <- diag(7:9)
odenet <- ODEnetwork(masses, dampers, springs)
position <- rep(10, 3)
velocity <- rep(0, 3)
odenet <- setState(odenet, position, velocity)
jac <- createJacobian(odenet)
}
