% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/imported_data.R
\name{imported_data}
\alias{imported_data}
\title{Download Open Case Study Imported Data}
\usage{
imported_data(casestudy, outpath = NULL)
}
\arguments{
\item{casestudy}{character string, name of the case study to pull data from.
The input name should follow the same naming scheme as the repository on GitHub:

ocs-bp-rural-and-urban-obesity

ocs-bp-air-pollution

ocs-bp-vaping-case-study

ocs-bp-opioid-rural-urban

ocs-bp-RTC-wrangling

ocs-bp-RTC-analysis

ocs-bp-youth-disconnection

ocs-bp-youth-mental-health

ocs-bp-school-shootings-dashboard

ocs-bp-co2-emissions

ocs-bp-diet}

\item{outpath}{character string, path to the directory where the downloaded
data folder should be saved to.}
}
\value{
If download is successful, the path to the downloaded data folder is
returned. Otherwise the appropriate error message is returned.
}
\description{
Download the specified case study imported data to use as you follow along the case study.
}
\details{
This function downloads the Open Case Study imported data
from GitHub and saves it in a new 'OCSdata/data/imported/' folder in
the specified directory. This makes it so all the imported data
are easily available in a local folder.
}
\examples{
tmp = tempfile()
dir.create(tmp)
imported_data('ocs-bp-opioid-rural-urban', outpath = tmp)

}
