% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autoboot.R, R/blockplot.R
\name{blockboot}
\alias{blockboot}
\alias{lolliblock}
\title{OBL: Optimal Block Length

Compute Optimal Block Length for Non-overlapping, Overlapping, Circular Block, tapered moving, and tapered circular Block Bootstrap method}
\usage{
blockboot(
  ts,
  R,
  seed,
  n_cores,
  methods = c("optnbb", "optmbb", "optcbb", "opttmbb", "opttcbb")
)

lolliblock(
  ts,
  R,
  seed,
  n_cores,
  methods = c("optnbb", "optmbb", "optcbb", "opttmbb", "opttcbb")
)
}
\arguments{
\item{ts}{univariate time series}

\item{R}{number of resample}

\item{seed}{RNG seed}

\item{n_cores}{number of core(s) to be used on your operaterating system}

\item{methods}{"optnbb", "optmbb", "optcbb", "opttmbb", "opttcbb"}
}
\value{
A data frame get printed to the console

A data frame get printed to the console
}
\description{
OBL: Optimal Block Length

Compute Optimal Block Length for Non-overlapping, Overlapping, Circular Block, tapered moving, and tapered circular Block Bootstrap method

OBL: Optimal Block Length

Compute Optimal Block Length for Non-overlapping, Overlapping, Circular Block, tapered moving, and tapered circular Block Bootstrap method
}
\section{Functions}{
\itemize{
\item \code{blockboot}: package helps to obtain the optimal block length of a time series data

\item \code{lolliblock}: package helps to obtain the optimal block length of a time series data
}}

\examples{
  set.seed(289805)
  ts <- arima.sim(n = 3, model = list(ar = 0.8, order = c(1, 0, 0)), sd = 1)
  blockboot(ts = ts, R = 2, seed = 6, n_cores = 1)

  set.seed(289805)
  ts <- arima.sim(n = 3, model = list(ar = 0.8, order = c(1, 0, 0)), sd = 1)
  lolliblock(ts, R = 2, seed = 6, n_cores = 1)

}
