% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NetworkToolbox--master.R
\name{edgerep}
\alias{edgerep}
\title{Edge Replication}
\usage{
edgerep(A, B, corr = c("pearson", "spearman", "kendall"), plot = FALSE)
}
\arguments{
\item{A}{An adjacency matrix of network A}

\item{B}{An adjacency matrix of network B}

\item{corr}{Correlation method for assessing the relatonship between the replicated edge weights.
Defaults to "pearson".
Set to "spearman" for non-linear or monotonic associations.
Set to "kendall" for rank-order correlations}

\item{plot}{Should there be a plot of the replicated weights?
Defaults to FALSE.
Set to TRUE for a plot to be produced}
}
\value{
Returns a list of the edges that replicated and their weights (replicatedEdges),
number of edges that replicate (replicated),
total number of edges (possibleA & possibleB),
the percentage of edges that replicate (percentageA & percentageB),
the density of edges (densityA & densityB),
the mean difference between edges that replicate (meanDifference),
the sd of the difference between edges that replicate (sdDifference),
and the correlation between the edges that replicate for both networks (correlation)
}
\description{
Computes the number of edges that replicate between two cross-sectional networks
}
\examples{
A<-TMFG(neoOpen)$A

B<-MaST(neoOpen)

edges<-edgerep(A,B)
}
\author{
Alexander Christensen <alexpaulchristensen@gmail.com>
}
