% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/netGDD.R
\name{netGDD}
\alias{netGDD}
\title{Calculate the Graphlet degree distribution (GDD) agreement between two networks}
\usage{
netGDD(net1, net2, mean = "arithmetic", i2inc = T)
}
\arguments{
\item{net1}{The input network, which should be one of incgraph and igraph objects}

\item{net2}{The input network, which should be one of incgraph and igraph objects}

\item{mean}{"arithmetic" or "geometric" mean to be used}

\item{i2inc}{Whether the input graph object should to transformed into incgraph object}
}
\value{
Agreement value between 0 and 1
}
\description{
Calculate the Graphlet degree distribution (GDD) agreement between two networks
}
\details{
netGDD(net1,net2,mean='arithmetic',i2inc=T)
}
\examples{

 nodes <-names(igraph::V(databases.net))

 net1 <-subnet(databases.net,sample(nodes,100))

 net2 <-subnet(databases.net,sample(nodes,100))

 netGDD(net1,net2)

}
