% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/turtle-functions.R
\name{hatch}
\alias{hatch}
\alias{hatch,agentMatrix,numeric,numeric-method}
\title{Hatch new \code{turtles}}
\usage{
hatch(turtles, who, n, breed)

\S4method{hatch}{agentMatrix,numeric,numeric}(turtles, who, n, breed)
}
\arguments{
\item{turtles}{\code{AgentMatrix} object representing the moving \code{agents}.}

\item{who}{Integer. Vector of the \code{who} numbers for the selected \code{turtles}.}

\item{n}{Integer. Vector of length 1 or of length \code{who}. Number of new \code{turtles}
to create for each parent.}

\item{breed}{Character. One \code{breed} name. If missing,
the created \code{turtles} are of the same \code{breed} as their parent \code{turtle}.}
}
\value{
\code{AgentMatrix} representing the \code{turtles} with the new
hatched ones.
}
\description{
Create new \code{turtles} from parent \code{turtles}.
}
\details{
The parent \code{turtle} must be contained in the \code{turtles}.

\if{html}{\out{<div class="sourceCode">}}\preformatted{     The created `turtles` inherit of all the data from the parent `turtle`,
     except for the `breed` if specified otherwise, and for the `who` numbers.
     The `who`" numbers of the `turtles` created take on following the highest
     `who` number among the `turtles`.

     All new hatched `turtles` are placed at the end of the `agentMatrix` object.
}\if{html}{\out{</div>}}
}
\examples{
w1 <- createWorld(minPxcor = 0, maxPxcor = 4, minPycor = 0, maxPycor = 4)
t1 <- createTurtles(n = 10, world = w1)
NLcount(t1)
t1 <- hatch(turtles = t1, who = 0, n = 2)
NLcount(t1)


}
\references{
Wilensky, U. 1999. NetLogo. http://ccl.northwestern.edu/netlogo/.
Center for Connected Learning and Computer-Based Modeling,
Northwestern University. Evanston, IL.
}
\seealso{
\url{https://ccl.northwestern.edu/netlogo/docs/dictionary.html#hatch}
}
\author{
Sarah Bauduin
}
