% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/event_size_plot.R
\name{event.size.plot}
\alias{event.size.plot}
\title{Plots the probability that a combination of a certain size appears}
\usage{
event.size.plot(netfacs.data)
}
\arguments{
\item{netfacs.data}{object resulting from netfacs() function}
}
\value{
Function returns a ggplot showing for each combination size the observed and expected probabilities of occurrance
}
\description{
The function takes all combination size in a netfacs object, and plots the distribution of ratios between the observed value and all randomisations
}
\examples{
### how do angry facial expressions differ from non-angry ones?
data(emotions_set)
angry.face <- netfacs(
  data = emotions_set[[1]],
  condition = emotions_set[[2]]$emotion,
  test.condition = "anger",
  ran.trials = 100,
  combination.size = 2
)

event.size.plot(angry.face)
}
