% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hello.R
\name{uTAR.grid}
\alias{uTAR.grid}
\title{Search for Threshold Value of A Two-Regime SETAR Model}
\usage{
uTAR.grid(y, p1, p2, d = 1, thrV = NULL, thrQ = c(0, 1),
  Trim = c(0.1, 0.9), include.mean = T)
}
\arguments{
\item{y}{a vector of time series.}

\item{p1, p2}{AR-orders of regime 1 and regime 2.}

\item{d}{delay for threshold variable, default is 1. (Apply to the external threshold variable too.)}

\item{thrV}{threshold variable. if it is not null, thrV must have the same length as that of y.}

\item{thrQ}{lower and upper limits for the possible threshold values.}

\item{Trim}{lower and upper trimming to control the sample size in each regime.}

\item{include.mean}{a logical value for including constant term.}
}
\value{
uTAR.grid returns a list with components:
\item{data}{the data matrix, y.}
\item{arorder}{AR orders of regimes 1 and 2.}
\item{residuals}{estimated innovations.}
\item{coefs}{a 2-by-(p+1) matrices. The first row shows the estimation results in regime 1, and the second row shows these in regime 2.}
\item{sigma}{estimated innovational covariance matrices of regimes 1 and 2.}
\item{nobs}{numbers of observations in regimes 1 and 2.}
\item{delay}{the delay for threshold variable.}
\item{model1,model2}{estimated models of regimes 1 and 2.}
\item{cnst}{logical values indicating whether the constant terms are included in regimes 1 and 2.}
\item{thr}{threshold value.}
\item{D}{a set of possible threshold values.}
\item{RSS}{residual sum of squares.}
\item{information}{information criterion.}
\item{sresi}{standardized residuals.}
}
\description{
Search for the threshold of a SETAR model for a given range of candidates for threshold values,
and perform recursive LS estimation.
The program uses a grid to search for threshold value.
It is a conservative approach, but might be more reliable than the Li and Tong (2016) procedure.
}
\examples{
phi=t(matrix(c(-0.3, 0.5,0.6,-0.3),2,2))
y=uTAR.sim(nob=2000, arorder=c(2,2), phi=phi, d=2, thr=0.2, cnst=c(1,-1),sigma=c(1, 1))
est1=uTAR.grid(y=y$series, p1=2, p2=2, d=2, thrQ=c(0,1),Trim=c(0.1,0.9),include.mean=TRUE)
}
