% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/triPLS1.R
\name{triPLS1}
\alias{triPLS1}
\title{Tri-PLS1: three-way PLS regressed onto a y vector}
\usage{
triPLS1(X, y, numComponents, tol = 1e-10, maxIter = 100)
}
\arguments{
\item{X}{Centered tensor of independent data}

\item{y}{Centered dependent variable}

\item{numComponents}{Number of components to fit}

\item{tol}{Relative change in loss for the model to converge (default 1e-10).}

\item{maxIter}{Maximum number of iterations (default 100).}
}
\value{
Model
}
\description{
Tri-PLS1: three-way PLS regressed onto a y vector
}
\examples{
set.seed(123)
X <- array(rnorm(100 * 5 * 4), dim = c(100, 5, 4))  # Random tensor (100 samples, 5 vars, 4 vars)
y <- rnorm(100)  # Random response variable
model <- triPLS1(X, y, numComponents = 2)
}
