% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run_nm.R
\name{run_nm_single}
\alias{run_nm_single}
\title{Run NONMEM jobs (single job)}
\usage{
run_nm_single(
  m,
  ignore.stdout = FALSE,
  ignore.stderr = FALSE,
  quiet = getOption("quiet_run"),
  intern = getOption("intern"),
  force = FALSE,
  cache_ignore_cmd = FALSE,
  cache_ignore_ctl = FALSE,
  cache_ignore_data = FALSE,
  return_cmd_only = FALSE
)
}
\arguments{
\item{m}{An nm object.}

\item{ignore.stdout}{Logical (default=\code{TRUE}). Parameter passed to \code{system_nm()}.}

\item{ignore.stderr}{Logical (default=\code{TRUE}). Parameter passed to \code{system_nm()}.}

\item{quiet}{Logical (default=\code{FALSE}). Should \code{system_nm()} output be piped to
screen?}

\item{intern}{Logical. \code{intern} argument to be passed to \code{system_nm()}.}

\item{force}{Logical (default = \code{FALSE}).  Force run even results unchanged.}

\item{cache_ignore_cmd}{Logical (default = \code{FALSE}). Should check \code{cmd} field
with cache?}

\item{cache_ignore_ctl}{Logical (default = \code{FALSE}). Should check control file
contents with cache?}

\item{cache_ignore_data}{Logical (default = \code{FALSE}). Should check dataset with
cache?}

\item{return_cmd_only}{Logical. Instead of running \code{cmd}, return the command
information in the form of a \code{tibble}.  This is intended for use in
\code{run_nm()} batch submission.}
}
\value{
\code{m} with \code{job_info} fields populated.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

Run nm objects.  Uses \code{system_nm()} to submit the \code{cmd()} value of object.
}
\details{
In grid environment it is recommended to run \code{\link[=nm_tran]{nm_tran()}} via the
RStudio 'Addin' prior to executing this code.

By default, when highlighting code and evaluating it via an RStudio app,
\code{run_nm()} will not execute and will just return the \code{nm} object.

For vector \code{nm} objects of length more than 1, all runs will be launched at
the same time.  This could overwhelm resources if not in a grid
environment.  In this case see \code{\link[=run_nm]{run_nm()}} for batched execution of a
vector valued \code{nm} object.
}
\examples{
## requires NONMEM to be installed
\dontrun{
m1 <- new_nm(
  run_id = "m1",
  based_on = "staging/Models/ADVAN2.mod",
  data_path = "DerivedData/data.csv"
) \%>\%
  cmd("execute {ctl_name} -dir={run_dir}") \%>\%
  fill_input() \%>\%
  run_nm()
}
}
\seealso{
\code{\link[=nm_tran]{nm_tran()}}
}
\keyword{internal}
