% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/searchColRow.R
\name{searchColRow}
\alias{searchColRow}
\title{Check row identifier in a model for necessary properties.}
\usage{
searchColRow(
  file,
  file.mod = file.mod,
  dir.data,
  file.data,
  translate.input,
  use.rds,
  args.fread,
  col.id,
  tab.row
)
}
\arguments{
\item{file}{a .lst (output) or a .mod (input) control stream
file. The filename does not need to end in .lst. It is
recommended to use the output control stream because it
reflects the model as it was run rather than how it is planned
for next run. However, see file.mod and dir.data.}

\item{file.mod}{The input control stream file path. Default is to
look for \"file\" with extension changed to .mod (PSN
style). You can also supply the path to the file, or you can
provide a function that translates the output file path to the
input file path. If dir.data is missing, the input control
stream is needed. This is because the .lst does not contain
the path to the data file. The .mod file is only used for
finding the data file. How to interpret the datafile is read
from the .lst file. The default can be configured using
NMdataConf. See dir.data too.}

\item{dir.data}{The data directory can only be read from the
control stream (.mod) and not from the output file (.lst). So
if you only have the output file, use dir.data to tell in
which directory to find the data file. If dir.data is
provided, the .mod file is not used at all.}

\item{file.data}{Specification of the data file path. When this is
used, the control streams are not used at all.}

\item{translate.input}{If TRUE (default), data columns are named
as interpreted by Nonmem (in $INPUT). If data file contains
more columns than mentioned in $INPUT, these will be named as
in data file (if data file contains named variables).}

\item{use.rds}{If an rds file is found with the exact same name
(except for .rds instead of say .csv) as the text file
mentioned in the Nonmem control stream, should this be used
instead? The default is yes, and NMwriteData will create this
by default too.}

\item{args.fread}{List of arguments passed to fread. Notice that
except for "input" and "file", you need to supply all
arguments to fread if you use this argument. Default values
can be configured using NMdataConf.}

\item{col.id}{The name of the subject ID column. Optional and only
used to calculate number of subjects in data. Default is
modified by NMdataConf.}

\item{applyFilters}{If TRUE (default), IGNORE and ACCEPT
statements in the Nonmem control streams are applied before
returning the data.}

\item{recover.cols}{recover columns that were not used in the
Nonmem control stream? Default is TRUE. Can only be negative
when translate=FALSE.}

\item{details}{If TRUE, metadata is added to output. In this case,
you get a list. Typically, this is mostly useful if
programming up functions which behavior must depend on
properties of the output. See details.}

\item{col.row}{The name of the row counter column. Optional and
only used to check whether the row counter is in the data.}

\item{quiet}{Default is to inform a little, but TRUE is useful for
non-interactive stuff.}
}
\value{
A character message about the findings if any
}
\description{
This function is only meant for internal use by NMscanData.
}
\keyword{internal}
