\docType{package}
\name{NMA-package}
\alias{NMA-package}
\title{The 'NMA' package.}
\description{
Network meta-analysis tools based on the contrast-based approach using the multivariate meta-analysis and meta-regression models (Noma et al., 2023c). Standard REML-based frequentist inference methods and the improved Noma-Hamura's inference and prediction methods (Noma et al., 2023ab) are available. Also, the local and global inconsistency tests based on the Higgins' design-by-treatment interaction model (Higgins et al., 2012) and the side-splitting method (Dias et al., 2010; Noma et al., 2017; Noma, 2023a) can be used. Standard graphical tools for network meta-analysis (e.g., network plot, ranked forest plot) are also available.
}
\references{
Dias, S., Welton, N. J., Caldwell, D. M., and Ades, A. E. (2010). Checking consistency in mixed treatment comparison meta-analysis. \emph{Statistics in Medicine} \strong{29}, 932-944.

Higgins, J. P., Jackson, D., Barrett, J. K., Lu, G., Ades, A. E., and White, I. R. (2012). Consistency and inconsistency in network meta-analysis: concepts and models for multi-arm studies. \emph{Research Synthesis Methods} \strong{3}, 98-110.

Nikolakopoulou, A., White, I. R., Salanti, G. (2021). Network meta-analysis. In: Schmid CH, Stijnen T, White IR, eds. \emph{Handbook of Meta-Analysis}. CRC Press; pp. 187-217.

Noma, H. (2023a). Sidesplitting using network meta-regression. Forthcoming.

Noma, H. (2023b). Within-study covariance estimators for network meta-analysis with contrast-based approach. Forthcoming.

Noma, H., Hamura, Y., Gosho, M., and Furukawa, T. A. (2023a). Kenward-Roger-type corrections for inference methods of network meta-analysis and meta-regression. \emph{Research Synthesis Methods}, \doi{10.1002/jrsm.1652}.

Noma, H., Hamura, Y., Sugasawa, S., and Furukawa, T. A. (2023b). Improved methods to construct prediction intervals for network meta-analysis. \emph{Research Synthesis Methods}, \doi{10.1002/jrsm.1651}.

Noma, H., Maruo, K., Tanaka, S. and Furukawa, T. A. (2023c). NMA: R package for network meta-analysis based on the multivariate meta-analysis and meta-regression models. Forthcoming.

Noma, H., Tanaka, S., Matsui, S., Cipriani, A., and Furukawa, T. A. (2017). Quantifying indirect evidence in network meta-analysis. \emph{Statistics in Medicine} \strong{36}, 917-927.

White, I. R., Barrett, J. K., Jackson, D., and Higgins, J. P. (2012). Consistency and inconsistency in network meta-analysis: model estimation using multivariate meta-regression. \emph{Research Synthesis Methods} \strong{3}, 111-125.
}
