% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Pathfinder.R
\name{findPathF3}
\alias{findPathF3}
\title{Find best subset of points for follow-up experiments, using F3 metric}
\usage{
findPathF3(tp, training1, training2, numSubSamples, spline = 1,
  resampleTraining = T, iter = 20, knots = 100, numPerts = 1000)
}
\arguments{
\item{tp}{A numerical vector of time points (or spatial coordinates along a single axis)}

\item{training1}{this is a numerical matrix of training data of experimental condition 1, where the rows represent different samples, columns represent different time points (or points on a single spatial axis), and the values correspond to measurements.}

\item{training2}{this is a numerical matrix of training data of experimental condition 2, where the rows represent different samples, columns represent different time points (or points on a single spatial axis), and the values correspond to measurements.}

\item{numSubSamples}{integer that represents the number of time points that will be subsampled}

\item{spline}{A positive integer representing the spline used to interpolate between knots when generating perturbations.  Note that this does NOT designate the spline used when calculating the L2-error.}

\item{resampleTraining}{A boolean designating whether the exact training data should be used (False) or whether a probability distribution of curves should be generated and training curves resampled (True).}

\item{iter}{A positive integer, representing the maximum number of iterations employed during time warping (see time_warping in fdasrvf library)}

\item{knots}{A positive integer-- for time warping to work optimally, the points must be evenly sampled.  This determines how many points do we evenly sample before conducting time warping}

\item{numPerts}{a positive integer, representing the number of sampled curves to output.}
}
\value{
An integer vector of the indices of the time points selected to be subsampled.  The actual time points can be found by \code{tp[output]}.  The length of this vector should be \code{numSubSamples}.
}
\description{
findPathF3 finds the best subset of points to sample from a time course (or spatial axis, along a single axis), based on a set of example curves. Specifically, it finds subsets of points that estimate the shape of the curve, normalised by the variance.
}
\examples{
 

#Set up data:
namAtlantic=CanadianWeather$region[as.character(colnames(CanadianWeather$monthlyTemp))]
atlanticCities=which(namAtlantic=="Atlantic")
matAtlantic=CanadianWeather$monthlyTemp[, names(atlanticCities)]

namContinental=CanadianWeather$region[as.character(colnames(CanadianWeather$monthlyTemp))]
continentalCities=which(namContinental=="Continental")
matContinental=CanadianWeather$monthlyTemp[, names(continentalCities)]

#find a set of points that helps capture the difference 
#between Atlantic and Continental cities, normalised by the variance
#make numPerts >=20 for real data
\donttest{a=findPathF3(c(1:12),  matAtlantic,  matContinental, 5, numPerts=3)} 
\donttest{print(a) #indices of months to select for follow-up experiments}
\donttest{print(rownames(CanadianWeather$monthlyTemp)[a]) #month names selected}

}
