% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gc_correct.R
\name{gc_correct}
\alias{gc_correct}
\title{Perform a GC bias correction on nipt sample}
\usage{
gc_correct(nipt_object, method = "LOESS", include_XY = F, span = 0.75,
  ref_genome = "hg37")
}
\arguments{
\item{nipt_object}{The object that will be corrected. This can either be a 
`NIPTSample` or a `NIPTControlGroup` object}

\item{method}{To select the LOESS based method use  \emph{"LOESS"},
to select the bin weights based method use  \emph{"bin"}.}

\item{include_XY}{Also apply correction to X and Y chromosomes?}

\item{span}{The span for the LOESS fit. Only applicable when LOESS method is used.}

\item{ref_genome}{The reference genome used. Either \emph{"hg37"} or \emph{"hg38"}
default = \emph{"hg37"}}
}
\value{
Depending on the input object either a NIPTSample or a NIPTControlGroup object
}
\description{
LOESS based GC bias correction algorithm described by Chen et al (2011)
}
\details{
GC content bias is the correlation between the number of reads mapped to a specific genomic 
region and the GC content of this region. In NIPTeR, two GC bias correction algorithms 
have been implemented, the LOESS based method introduced by Chen et al. (2011) and the bin 
weight based method described by Fan and Quake (2010).
}
\examples{
\dontrun{
##Correct NIPTSample object using LOESS method
loess_corrected_sample <- gc_correct(nipt_object = sample_of_interest, method = "LOESS",
                                     include_XY = F, span = 0.75)
##Correct NIPTControlGroup object using bin method
gc_bin_corrected_control_group <- gc_correct(nipt_object = control_group, method = "bin", 
                                             include_XY = T)
}

}

