% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{ngchmNewBar}
\alias{ngchmNewBar}
\title{Create a new Classification Bar for a NGCHM}
\usage{
ngchmNewBar(
  label,
  type,
  data,
  colors = NULL,
  display = "visible",
  thickness = as.integer(10),
  merge,
  barType,
  loBound,
  hiBound,
  fgColor,
  bgColor
)
}
\arguments{
\item{label}{The name by which the classification bar will be known.}

\item{type}{The string "discrete" or the string "continuous".}

\item{data}{A vector of the data to be displayed in the classification bar. names(data) must be defined.}

\item{colors}{A color map specifying how the data should be rendered.}

\item{display}{Whether the classification bar will be "hidden" or "visible" (default).}

\item{thickness}{The thickness of the classification bar in pixels. (Default 10).}

\item{merge}{Algorithm for merging classifications when necessary ("average", "peakColor", "specialColor", or "mostCommon").}

\item{barType}{Type of covariate bar ("color_plot", "scatter_plot", "bar_plot"). Default "color_plot".}

\item{loBound}{Low bound for bar and scatter plots. Default minimum data value.}

\item{hiBound}{High bound for bar and scatter plots.  Default maximum data value.}

\item{fgColor}{Foreground color for bar and scatter plots.  Default black.}

\item{bgColor}{Background color for bar and scatter plots.  Default white.}
}
\value{
An object of class ngchmBar
}
\description{
This function is deprecated and will be removed in a future version.  Please use chmNewCovariateBar.
This function creates a new Classification Bar suitable for adding to a Next Generation Clustered Heat Map.
}
\seealso{
\linkS4class{ngchmBar}

\code{\link[=chmNewColorMap]{chmNewColorMap()}}

\code{\link[=chmNewCovariateBar]{chmNewCovariateBar()}}

\code{\link[=chmAddCovariateBar]{chmAddCovariateBar()}}
}
