% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as-genes-fgs.r
\name{as_genes_fgs}
\alias{as_genes_fgs}
\title{Create single-gene FGS}
\usage{
as_genes_fgs(Net.list, Lowercase = 1)
}
\arguments{
\item{Net.list}{the global network object, pre-created using \code{\link{import.net}}}

\item{Lowercase}{render gene/protein IDs lower-case (Default:1)}
}
\description{
Each network node X becomes an FGS itself, so that e.g. each ID 'X' generates a list entry named 'X', the content of which is c('X'), i.e. this same gene/protein. The total length of the FGS list then equals the number of nodes in the network. This is a way to create single-gene "quasi-pathways" for a more specific network enrichment analysis.
}
\examples{
data(net.kegg)
netpath <- net.kegg
net <- import.net(netpath)
fgs.genes <- as_genes_fgs(net)
print(fgs.genes[1:10])
}
\seealso{
\code{\link{import.net}}, \code{\link{import.gs}}
}

