% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transform.R
\name{transf_time_to_hms}
\alias{transf_time_to_hms}
\title{Convert time columns to \code{hms} format}
\usage{
transf_time_to_hms(data, study, release = "latest")
}
\arguments{
\item{data}{tibble. The data to be converted.}

\item{study}{character. NBDC study (One of \code{"abcd"} or \code{"hbcd"}).}

\item{release}{character. Release version (Default: \code{"latest"}).}
}
\value{
A tibble with time columns converted to \code{hms} format.
}
\description{
This function converts time columns to \code{hms} format.
}
\details{
The input data with time columns are expected to have character format
of \code{"HH:MM:SS"}. If it is not in this format, the function will return NA
for that row.
}
\examples{
\dontrun{
transf_time_to_hms(data)
}
}
