% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cen1way.R
\name{cen1way}
\alias{cen1way}
\title{Peto-Peto one-factor test}
\usage{
cen1way(x1, x2, group, mcomp.method = "BH", printstat = TRUE)
}
\arguments{
\item{x1}{The column of data values plus detection limits}

\item{x2}{The column of indicators, where 1 (or \code{TRUE}) indicates a detection limit in the y1 column, and 0 (or \code{FALSE}) indicates a detected value in y1.}

\item{group}{Grouping or factor variable. Can be either a text or numeric value indicating the group assignment.}

\item{mcomp.method}{One of the standard methods for adjusting p-values for multiple comparisons.  Type ?p.adjust for the list of possible methods. Default is Benjamini-Hochberg "BH" false discover rate.}

\item{printstat}{Logical \code{TRUE}/\code{FALSE} option of whether to print the resulting statistics in the console window, or not.  Default is \code{TRUE.}}
}
\value{
A list of summary statistics for each group evaluated containing the following components:
\itemize{
\item \code{N} Number of samples
\item \code{PctND} Percentage of non-detects
\item \code{KMmean} Kaplan-Meier estimate of the mean
\item \code{KMsd} Kaplan-Meier estimate of standard deviation
\item \code{KMmedian} Kaplan-Meier estmate of the median
}

Peto-Peto test results including Chi-Squared value, degrees of freedom and \code{p-value} of the test.

If more than two groups, \code{p-values} of the pairwise multiple comparisons, adjusted using the BH false-discovery rate, are reported.
}
\description{
Performs a Peto-Peto nonparametric test of differences in cdfs between groups.  If more than two groups, the test is followed by a nonparametric multiple comparison test.  Uses the BH method of adjusting p-values.
}
\examples{
data(PbHeron)

# Two Groups
cen1way(PbHeron$Liver,PbHeron$LiverCen,PbHeron$DosageGroup)

# More than two groups
cen1way(PbHeron$Liver,PbHeron$LiverCen,PbHeron$Group)
}
\references{
Helsel, D.R., 2011. Statistics for Censored Environmental Data using Minitab and R, 2nd ed. John Wiley & Sons, USA, N.J.

Peto, R., Peto, J., 1972. Asymptotically Efficient Rank Invariant Test Procedures. Journal of the Royal Statistical Society. Series A (General) 135, 185. \doi{https://doi.org/10.2307/2344317}

Benjamini, Y., Hochberg, Y., 1995. Controlling the False Discovery Rate: A Practical and Powerful Approach to Multiple Testing.  Journal of the Royal Statistical Society. Series B (Methodological), 57, 289-300.
}
