% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SummaryDistancia.R
\name{SummaryDistancia}
\alias{SummaryDistancia}
\title{Resumo das informacoes de cada tratamento em funcao da dissimilaridade}
\usage{
SummaryDistancia(Dist,ndec=2)
}
\arguments{
\item{Dist}{Matriz de dissimilaridade}

\item{ndec}{Valor numerico indicando o numero de casas decimais.}
}
\value{
Retorna informacoes importantes sobre cada tratamento em relacao aos
demais como distancia media, menor distancia, maior distancia, tratamento
mais proximo, tratamento mais distante etc.
}
\description{
Esta funcao apresenta informacoes que resumem a matriz de dissimilaridade
}
\examples{
 data(Dados.FMI.Quali)
DadosQuali=ApplyDissimilaridade(Dados.FMI.Quali[,6:10],Dados.FMI.Quali[,2])
Dist=Distancia(DadosQuali,1)
SummaryDistancia(Dist)
}
\references{
PlayList "Curso de Analise Multivariada":
 https://www.youtube.com/playlist?list=PLvth1ZcREyK72M3lFl7kBaHiVh5W53mlR


CRUZ, C.D. and CARNEIRO, P.C.S.  Modelos biometricos aplicados ao
  melhoramento genetico. 3nd Edition. Vicosa, UFV, v.2, 2014. 668p.  (ISBN: 8572691510)

FERREIRA, D.F. Estatistica Multivariada. (2018) 3ed. UFLA. 624p. (ISBN 13:978 8581270630)

 HAIR, J.F. Multivariate Data Analysis.  (2016) 6ed. Pearson Prentice HalL.
  (ISBN 13:978 0138132637)
}
\seealso{
/code{/link{dist}/}
}
