% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Estimation.r
\name{Esti_Skew_Variance_Th}
\alias{Esti_Skew_Variance_Th}
\title{Asymptotic Variance of the estimated skewness vector}
\usage{
Esti_Skew_Variance_Th(cum)
}
\arguments{
\item{cum}{The theoretical/estimated cumulants up to order 6 in vector form}
}
\value{
The matrix of theoretical/estimated variance
}
\description{
Asymptotic Variance of the estimated skewness vector
}
\examples{
alpha<-c(10,5)
omega<-diag(rep(1,2))
MC <- distr_SkewNorm_MomCum_Th(r = 6,omega,alpha)
cum <- MC$CumX
VS <- Esti_Skew_Variance_Th(cum)
}
\references{
Gy.Terdik, Multivariate statistical methods - Going beyond the linear,
Springer 2021. Ch.6, formula (6.13)
}
\seealso{
Other Estimation: 
\code{\link{Esti_EVSK}()},
\code{\link{Esti_Kurt_Variance_Th}()},
\code{\link{Esti_MMom_MCum}()},
\code{\link{Esti_Skew_Mardia}()}
}
\concept{Estimation}
