% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/unabridge.R
\name{unabridge}
\alias{unabridge}
\title{Split abridged death counts into single-age data}
\usage{
unabridge(dxc, nx, inter, plot = FALSE)
}
\arguments{
\item{dxc}{age- and cause-specific death counts by age group}

\item{nx}{age-specific exposures by age group}

\item{inter}{matrix containing the begining and end of the age intervals}

\item{plot}{should a plot comparison of abridged and unabridged data be produced (logical)}
}
\value{
The function returns a list of three objects.
\describe{
 \item{dxc}{a matrix of cause-specific single-age death counts (rows = ages, columns = causes)}
 \item{nx}{a vector of single-age exposures}
 \item{x}{a vector of the age (begining of the single-age intervals)}
}
}
\description{
This function applies spline smoothing and interpolation in order to transform abridged age- and cause-specific death counts and exposures into single-age data.
}
\details{
The method used is inspired by the \href{http://www.mortality.org/Public/Docs/MethodsProtocol.pdf}{method protocol} of the Human Mortality Database, albeit using a built-in spline smoother with fewer constraints.
The age- and cause-specific death counts are first transformed into age- and cause-specific cumulative death counts.
Smoothing cubic splines are then fitted to these cause-specific cumulative distributions, from which singe-year estimates are interpolated.
Single-age death counts are then computed by taking the first derivatives (slopes) of the interpolated cumulative values.

The first age group (age 0) is treated separately in order to facilitate the estimation of the spline.
Practically, it is removed from the series before the interpolation and subsequently added to the unabridged death counts.

Exposures are treated in a similar fashion, keeping the first age group together with the rest of the series.

If \code{plot == TRUE}, two plots are produced, from the cumulative and original age-specific death counts respectively.
Both plots contain abridged (black) and unabridged (red) figures. In the second plot, the unabrided figures are inflated by the size of the original age interval to allow for a visual inspection of the quality of fit.
These graphs may include a few small negative death counts, as the spline fitted on the cumulative death counts is not constrained to be monotonically increasing. These are later corrected in the output.
}
\examples{

data(USA2000m)

unabr <- unabridge(dxc = USA2000m$dxc, nx = USA2000m$nx, inter = USA2000m$inter, plot = TRUE)

}
\seealso{
\link{HCD2MH}, \link{smooth.spline}
}
