% Generated by roxygen2 (4.0.2): do not edit by hand
\name{meshDist.matrix}
\alias{meshDist}
\alias{meshDist.matrix}
\alias{meshDist.mesh3d}
\title{calculates and visualises distances between surface meshes or 3D coordinates and a surface mesh.}
\usage{
\method{meshDist}{matrix}(x, mesh2 = NULL, distvec = NULL, from = NULL,
  to = NULL, steps = 20, ceiling = FALSE, uprange = 1, plot = TRUE,
  sign = TRUE, tol = NULL, type = c("s", "p"), radius = NULL,
  displace = FALSE, add = FALSE, ...)

meshDist(x, ...)

\method{meshDist}{mesh3d}(x, mesh2 = NULL, distvec = NULL, from = NULL,
  to = NULL, steps = 20, ceiling = FALSE, file = "default",
  imagedim = "100x800", uprange = 1, ray = FALSE, raytol = 50,
  save = FALSE, plot = TRUE, sign = TRUE, tol = NULL,
  displace = FALSE, shade = TRUE, method = c("morpho", "vcglib"),
  add = FALSE, ...)
}
\arguments{
\item{x}{reference mesh; object of class "mesh3d" or a n x 3 matrix
containing 3D coordinates.}

\item{mesh2}{target mesh: either object of class "mesh3d" or a character
pointing to a surface mesh (ply, obj or stl file)}

\item{distvec}{vector: optional, a vector containing distances for each
vertex of mesh1, if distvec != NULL, x will be ignored.}

\item{from}{numeric: minimum distance to be colorised; default is set to 0
mm}

\item{to}{numeric: maximum distance to be colorised; default is set to the
maximum distance}

\item{steps}{integer: determines break points for color ramp: n steps will
produce n-1 colors.}

\item{ceiling}{logical: if TRUE, the next larger integer of "to" is used}

\item{uprange}{numeric between 0 and 1: restricts "to" to a quantile of
"to", if to is NULL.}

\item{plot}{logical: visualise result as 3D-plot and distance charts}

\item{sign}{logical: request signed distances. Only meaningful, if mesh2 is
specified or distvec contains signed distances.}

\item{tol}{numeric: threshold to color distances within this threshold
green.}

\item{type}{character: "s" shows coordinates as spheres, while "p" shows 3D
dots.}

\item{radius}{determines size of spheres; if not specified, optimal radius
size will be estimated by centroid size of the configuration.}

\item{displace}{logical: if TRUE, displacement vectors between original and
closest points are drawn colored according to the distance.}

\item{add}{logical: if TRUE, visualization will be added to the rgl window currently in focus}

\item{file}{character: filename for mesh and image files produced. E.g.
"mydist" will produce the files mydist.ply and mydist.png}

\item{imagedim}{character of type 100x200 where 100 determines the width and
200 the height of the image.}

\item{ray}{logical: if TRUE, the search is along vertex normals.}

\item{raytol}{maximum distance to follow a normal.}

\item{save}{logical: save a colored mesh.}

\item{shade}{logical: if FALSE, the rendering of the colored surface will be
supressed.}

\item{method}{accepts: "vcglib" and "morpho" (and any abbreviation). vcglib
uses a command line tool using vcglib headers, morpho uses fortran routines
based on a kd-tree search for closest triangles.}

\item{\dots}{additional arguments passed to \code{\link{shade3d}}. See
\code{\link{rgl.material}} for details.}
}
\value{
Returns an object of class "meshDist" if the input is a surface mesh
and one of class "matrixDist" if input is a matrix containing 3D
coordinates.
\item{colMesh }{object of mesh3d with colors added}
\item{dists }{vector with distances}
\item{cols }{vector with color values}
\item{params }{list of parameters used}
}
\description{
calculates and visualises distances between surface meshes or 3D coordinates
and a surface mesh.
}
\details{
calculates the distances from a mesh or a set of 3D coordinates to another
at each vertex; either closest point or along the normals

this function needs the command line tools from the Auxiliaries section in
\url{http://sourceforge.net/projects/morpho-rpackage/files/Auxiliaries}
installed.
}
\examples{
require(rgl)
data(nose)##load data
##warp a mesh onto another landmark configuration:
warpnose.long <- warp.mesh(shortnose.mesh, shortnose.lm, longnose.lm)
\dontrun{
meshDist(warpnose.long, shortnose.mesh, method="m")
}
#use signed distances and
#color distances < 0.01 green:
\dontrun{
meshDist(warpnose.long, shortnose.mesh, sign=TRUE, tol=0.01, method="m")
}
}
\author{
Stefan Schlager
}
\references{
Detection of inside/outside uses the algorithm proposed in:

Baerentzen, Jakob Andreas. & Aanaes, H., 2002. Generating Signed Distance
Fields From Triangle Meshes. Informatics and Mathematical Modelling, .
}
\seealso{
\code{\link{render.meshDist}}, , \code{\link{export.meshDist}},
\code{\link{shade3d}}
}

