% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coo-ldk-utilities.R
\name{links_all}
\alias{links_all}
\title{Creates links (all pariwise combinations) between landmarks}
\usage{
links_all(coo)
}
\arguments{
\item{coo}{a matrix (or a list) of (x; y) coordinates}
}
\value{
a matrix that can be passed to \link{ldk_links}, etc. The columns
are the row ids of the original shape.
}
\description{
Creates links (all pariwise combinations) between landmarks
}
\examples{
data(wings)
w <- wings[1]
coo_plot(w)
links <- links_all(w)
ldk_links(w, links)
}
\seealso{
Other ldk helpers: \code{\link{def_links}},
  \code{\link{ldk_check}}, \code{\link{links_delaunay}}
}

