% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cl-def-Out.R
\name{as.Out}
\alias{as.Out}
\title{Convert an OutCoe object into an Out object}
\usage{
as.Out(object, OutCoe, nb.pts = 120)
}
\arguments{
\item{object}{an OutCoe object}

\item{OutCoe}{used by \code{as}, useless for the front user}

\item{nb.pts}{number of point for the reconstructed outlines}
}
\value{
an \link{Out} object.
}
\description{
Uses the \code{$method} to do the inverse corresponding function. For instance,
an \link{OutCoe} object obtained with \link{efourier}, will be converted to an \link{Out}
object (outlines from harmonic coefficients), using \link{efourier_i}.
}
\details{
Note that the 'positionnal' coefficients (\code{ao} and \code{co} if any) are lost, so for a proper
comparison between a raw \code{Out} and a \code{Out} from \code{Out -> OutCoe -> Out},
the raw \code{Out} should be centered.

This method is useful since it allows a direct inspection at how Fourier-based
methods handle outlines, and in particular how they normalize it (when they do). If you
have bad "reconstruction" using \code{as.Out}, this probably means that you have to think
about alternative alignements on the raw outlines. For instance, it is obvious
that normalization does a good job on the bottle example, yet it -pi/2 turns the "outlines"
yet neutral for further analysis (and that can be manage with the argument \code{rotate.shp} in
functions/methods that use reconstructed outlines, e.g. \link{plot.PCA}).
}
\examples{
data(bot)
bot <- coo_center(bot)
bot.f <- rfourier(bot, 120)
bot.fi <- as.Out(bot.f)
op <- par(mfrow=c(1, 2))
stack(bot, title="raw bot")
stack(bot.fi, title="outlines from bot.f")
par(op)
}

