% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{dataMining}
\alias{dataMining}
\alias{whichDiscrete}
\alias{discreteVariables_as.character}
\alias{standardizeDataset}
\alias{discretizeVariablesEWdis}
\alias{discreteVariablesStates}
\alias{nstates}
\alias{quantileIntervals}
\alias{scaleData}
\title{Functions to Manipulate a Dataset}
\usage{
whichDiscrete(dataset, discreteVariables)

discreteVariables_as.character(dataset, discreteVariables)

standardizeDataset(dataset)

discretizeVariablesEWdis(dataset, numIntervals, factor = FALSE,
  binary = FALSE)

discreteVariablesStates(namevariables, discreteData)

nstates(DiscreteVariablesStates)

quantileIntervals(X, numIntervals)

scaleData(dataset, scale)
}
\arguments{
\item{dataset}{A dataset of class \code{"data.frame"}. Tha variables of the dataset can be discrete and continuous.}

\item{discreteVariables}{A \code{"character"} array with the name of the discrete variables}

\item{numIntervals}{Numbers of intervals used to split the domain.}

\item{factor}{By default \code{FALSE}, i.e. The variables are taken as \code{"character"};
if \code{TRUE}, they would be taken as \code{"factor"}.}

\item{binary}{By default \code{FALSE}, i.e. only binary entries are used for continuous variables;
if \code{TRUE}, binary entries are used to discretize the full data taking into account the states
the discrete variables.}

\item{namevariables}{an array with the names of the varibles.}

\item{discreteData}{A discretized dataset of class \code{"data.frame"}.}

\item{DiscreteVariablesStates}{The output of the function \code{discreteVariablesStates}.}

\item{X}{A \code{"numeric"} vector with the data values of a continuous variable.}

\item{scale}{A \code{"numeric"} vector if is a singles variable,if not a \code{"list"} containing
the name of the variable and the scale value.}
}
\description{
Collection of functions for discretizing, standardizing, converting factors to 
characters and other usufull methods to manipulate datasets.
}
\details{
\code{whichDiscrete()} selects the position of the discrete variables.

\code{discreteVariables_as.character()} transforms the values of the discrete variables to character values.

\code{standardizeDataset()} standarizes a data set.

\code{discretizeVariablesEWdis()} discretizes a dataset using intervals with equal width.

\code{discreteVariablesStates()} extracts the states of the qualitative variables.

\code{nstates()} computes the length of the states of the discrete variables.

\code{quantileIntervals()} selects the quantiles of a variable taking into account the number of intervals
you want to split the domain of the variable.
}
\examples{
## dataset: 2 continuous variables, 1 discrete variable.
data <- data.frame(X = rnorm(100),Y = rexp(100,1/2), Z = as.factor(rep(c("s","a"), 50)))
disVar <- "Z" ## Discrete variable
class(data[,disVar]) ## factor

data <- discreteVariables_as.character(dataset = data, discreteVariables = disVar)
class(data[,disVar]) ## character

whichDiscrete(dataset = data, discreteVariables = "Z")

standData <- standardizeDataset(dataset = data)

disData <- discretizeVariablesEWdis(dataset = data, numIntervals = 3)

l <- discreteVariablesStates(namevariables = names(data), discreteData = disData)

nstates(DiscreteVariablesStates = l)

## Continuous variables
quantileIntervals(X = data[,1], numIntervals = 4)
quantileIntervals(X = data[,2], numIntervals = 10)
}
