% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/4_auxiliaryFunctions.R
\name{gofMobilityNetwork}
\alias{gofMobilityNetwork}
\alias{gofDistributionNetwork}
\alias{plot.gof.stats.monan}
\title{gofMobilityNetwork}
\usage{
gofMobilityNetwork(ans, simulations, gofFunction, lvls = NULL)

gofDistributionNetwork(ans, simulations, gofFunction, lvls = NULL)

\method{plot}{gof.stats.monan}(x, lvls, ...)
}
\arguments{
\item{ans}{An object of class "result.monan" resulting from an estimation with the function \code{\link[=estimateMobilityNetwork]{estimateMobilityNetwork()}}.}

\item{simulations}{The simulated outcomes with which the observed statistics are compared.
Usually, they are stored in the ans$deps, in case deps = TRUE was specified in the
estimation.}

\item{gofFunction}{A gof function that specifies which auxiliary outcome should be used,
e.g., "getIndegree" or "getTieWeights".}

\item{lvls}{The values for which the gofFunction should be calculated/plotted.}

\item{x}{An object of class "gof.stats.monan".}

\item{...}{Additional plotting parameters, use discouraged.}
}
\value{
The function \code{gofMobilityNetwork} returns a list containing
(1) the observed values of the auxiliary statistics and
(2) a list of the simulated values of the auxiliary statistics.

The function \code{plot.gof.stats.monan} returns violin plots of the
gof tests with observed values superimposed in red.
}
\description{
Akin to ERGMs, goodness of fit testing is available to see whether auxiliary
statistics are well captured by the model. The logic behind gof testing for network models is outlined in
Hunter et al. (2008) and Lospinoso and Snijders (2019).
}
\examples{
# goodness of fit
myGofIndegree <- gofMobilityNetwork(ans = myResDN, 
                                        simulations = myResDN$deps, 
                                        gofFunction = getIndegree, 
                                        lvls = 1:100)

myGofTieWeight <- gofMobilityNetwork(ans = myResDN, 
                                         simulations = myResDN$deps, 
                                         gofFunction = getTieWeights, 
                                         lvls = 1:30)
plot(myGofIndegree,  lvls = 20:70)
plot(myGofTieWeight, lvls = 1:15)
}
\references{
Hunter, D. R., Goodreau, S. M., & Handcock, M. S. (2008). Goodness of fit of social network models.
\emph{Journal of the american statistical association}, 103(481), 248-258.

Lospinoso, J., & Snijders, T. A. (2019).
Goodness of fit for stochastic actor-oriented models. \emph{Methodological Innovations}, 12(3).
}
\seealso{
\code{\link[=getIndegree]{getIndegree()}}, \code{\link[=getTieWeights]{getTieWeights()}}
}
