% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/labelFrequency.R
\name{mixnorm}
\alias{mixnorm}
\title{Parameter Estimation for Uni- or Multivariate Normal Mixture Models}
\usage{
mixnorm(x, C = 2, sigma.known = NULL, ini = NULL, tol = 1e-05)
}
\arguments{
\item{x}{an n by p matrix of observations where n is the number of observations and
s is the dimension of data.}

\item{C}{number of mixture components. Default is 2.}

\item{sigma.known}{a vector or matrix of component standard deviations. Default is NULL, which means
the standard deviations are unknown.}

\item{ini}{initial values for the parameters. Default is NULL, which randomly sets the initial values
using the given observations. If specified, it can be a list with the form of \code{list(mu, pi, sigma)}, where
\code{mu} is a vector of C component means,
\code{pi} is a vector of C mixing proportions, and
\code{sigma} is a vector of C component standard deviations (this element is only needed when \code{sigma.known} is not given).}

\item{tol}{stopping criteria for the algorithm. Default is 1e-05.}
}
\value{
A list containing the following elements:
\item{mu}{estimated component means.}
\item{sigma}{estimated component standard deviations. Only returned when \code{sigma.known} is not specified.}
\item{pi}{estimated mixing proportions.}
\item{p}{matrix containing estimated classification probabilities where the (i, j)th element is the probability of
the jth observation belonging to the ith component.}
\item{lik}{final likelihood.}
}
\description{
`mixnorm' is used to estimate parameters of a normal mixture model with equal variance.
The function supports both one-dimensional and multi-dimensional data.
}
\examples{
# See examples for the `complh' function.
}
\seealso{
\code{\link{complh}}, \code{\link{distlat}}
}
