% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MethyBayes.R
\name{MethyBayes}
\alias{MethyBayes}
\title{This is a function to produce methylation identification result.}
\usage{
MethyBayes(data, n1, n2)
}
\arguments{
\item{data}{A list of read counts, methylated read counts and
sites commonly mapped by all replicates.}

\item{n1}{Number of replicates in treatment experiment.}

\item{n2}{Number of replicates in control experiment.}
}
\value{
Methylation identification result matrix, first column is the list
of sites, second column is the list of identification result.
}
\description{
This function returns the methylation identification result for all sites
commonly mapped by all replicates under two experimental conditions.
}
\examples{
\dontrun{
 data("case1", "case2", "control1", "control2")
 read_counts <- seqdata(list(case1, case2), list(control1, control2))
 ident <- MethyBayes(read_counts, 2, 2)
}
}
\references{
Wang, H., He, C., Kushwaha, G., Xu, D., \& Qiu, J. (2016).
A full Bayesian partition model for identifying hypo-and hyper-methylated
loci from single nucleotide resolution sequencing data. BMC bioinformatics,
17(1), 71.
}

