% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/mr_mbe-methods.R
\docType{methods}
\name{mr_mbe}
\alias{mr_mbe}
\alias{mr_mbe,MRInput-method}
\title{Mode-based method of Hartwig}
\usage{
mr_mbe(
  object,
  weighting = "weighted",
  stderror = "simple",
  phi = 1,
  seed = 314159265,
  iterations = 10000,
  distribution = "normal",
  alpha = 0.05
)

\S4method{mr_mbe}{MRInput}(
  object,
  weighting = "weighted",
  stderror = "delta",
  phi = 1,
  seed = 314159265,
  iterations = 10000,
  distribution = "normal",
  alpha = 0.05
)
}
\arguments{
\item{object}{An \code{MRInput} object.}

\item{weighting}{Whether the analysis should be \code{"weighted"} (the default option) or \code{"unweighted"}.}

\item{stderror}{Whether standard error estimates should be i) \code{"simple"} - calculated as the first-order term from the delta expansion - standard error of the association with the outcome divided by the association with the exposure), or ii) \code{"delta"} - calculated as the second-order term from the delta expansion (the default option). The second-order term incorporates uncertainty in the genetic association with the exposure -- this uncertainty is ignored using the simple weighting. The \code{"simple"} option is referred to by Hartwig et al as "assuming NOME", and the \code{"delta"} option as "not assuming NOME".}

\item{phi}{The choice of bandwidth in the kernel-smoothly density method. A value of 1 (the default value) represents the bandwidth value selected by the modified Silverman's bandwidth rule, as recommended by Hartwig et al. A value of 0.5 represents half that value, and so on.}

\item{seed}{The random seed to use when generating the bootstrap samples used to calculate the confidence intervals (for reproducibility). The default value is 314159265. If set to \code{NA}, the random seed will not be set (for example, if the function is used as part of a larger simulation).}

\item{iterations}{Number of iterations to use in the bootstrap procedure.}

\item{distribution}{The type of distribution used to calculate the confidence intervals, can be \code{"normal"} (the default option) or \code{"t-dist"}.}

\item{alpha}{The significance level used to calculate the confidence interval. The default value is 0.05.}
}
\value{
The output from the function is an \code{MRMBE} object containing:

 \item{Exposure}{A character string giving the name given to the exposure.}
 \item{Outcome}{A character string giving the name given to the outcome.}
 \item{Weighting}{A character string \code{"weighted"} or \code{"unweighted"}.}
 \item{StdErr}{A character string \code{"simple"} or \code{"delta"}.}
 \item{Phi}{The value of the bandwidth factor.}
 \item{Estimate}{The value of the causal estimate.}
 \item{StdError}{Standard error of the causal estimate.}
 \item{CILower}{The lower bound of the causal estimate based on the estimated standard error and the significance level provided.}
 \item{CIUpper}{The upper bound of the causal estimate based on the estimated standard error and the significance level provided.}
 \item{Alpha}{The significance level used when calculating the confidence intervals.}
 \item{Pvalue}{The p-value associated with the estimate (calculated as Estimate/StdError as per Wald test) using a normal or t-distribution (as specified in \code{distribution}).}
 \item{SNPs}{The number of genetic variants (SNPs) included in the analysis.}
}
\description{
The \code{mr_mbe} function implements the mode-based method introduced by Hartwig, Bowden and Davey Smith (2017).
}
\details{
The mode-based estimation (MBE) method takes the variant-specific ratio estimates from each genetic variant in turn, and calculates the modal estimate. This is implemented by constructing a kernel-smoothed density out of the ratio estimates, and taking the maximum value as the modal estimate. The standard error is calculated by a bootstrap procedure, and confidence intervals based on the estimate having a normal distribution.

The method should give consistent estimates as the sample size increases if a plurality (or weighted plurality) of the genetic variants are valid instruments. This means that the largest group of variants with the same causal estimate in the asymptotic limit are the valid instruments.
}
\examples{
mr_mbe(mr_input(bx = ldlc, bxse = ldlcse, by = chdlodds, byse = chdloddsse), iterations=100)
mr_mbe(mr_input(bx = ldlc, bxse = ldlcse, by = chdlodds, byse = chdloddsse),
   phi=0.5, iterations=100)
mr_mbe(mr_input(bx = ldlc, bxse = ldlcse, by = chdlodds, byse = chdloddsse),
   weighting="weighted", stderror="delta", iterations=100)
# iterations set to 100 to reduce computational time,
#  more iterations are recommended in practice

}
\references{
Fernando Pires Hartwig, George Davey Smith, Jack Bowden. Robust inference in summary data Mendelian randomization via the zero modal pleiotropy assumption. International Journal of Epidemiology 2017; 46(6): 1985-1998. doi: 10.1093/ije/dyx102.
}
